// Copyright 3D Control Systems, Inc. All Rights Reserved 2017-2019.
// Built in San Francisco.

// This software is distributed under a commercial license for personal,
// educational, corporate or any other use.
// The software as a whole or any parts of it is prohibited for distribution or
// use without obtaining a license from 3D Control Systems, Inc.

// All software licenses are subject to the 3DPrinterOS terms of use
// (available at https://www.3dprinteros.com/terms-and-conditions/),
// and privacy policy (available at https://www.3dprinteros.com/privacy-policy/)

import QtQuick 2.7
import AppStyle 1.0

Item {
    id: keyValueItem
    height: keyTextItem.height
    property string keyText: ""
    property string valueText: ""

    Text {
        id: keyTextItem
        anchors {
            left: parent.left
            top: parent.top
        }
        font.pixelSize: 20
        color: AppStyle.textColor
        text: keyText
    }

    Text {
        id: valueTextItem
        anchors {
            right: parent.right
            top: parent.top
        }
        font.pixelSize: 20
        color: AppStyle.textColor
        text: valueText
    }
}
