// Copyright 3D Control Systems, Inc. All Rights Reserved 2017-2019.
// Built in San Francisco.

// This software is distributed under a commercial license for personal,
// educational, corporate or any other use.
// The software as a whole or any parts of it is prohibited for distribution or
// use without obtaining a license from 3D Control Systems, Inc.

// All software licenses are subject to the 3DPrinterOS terms of use
// (available at https://www.3dprinteros.com/terms-and-conditions/),
// and privacy policy (available at https://www.3dprinteros.com/privacy-policy/)

import QtQuick 2.7
import QtQuick.Controls 2.4
import AppStyle 1.0

Button {
    id: control
    width: visible
           ? (btnText.paintedWidth > defaultWidth * 0.9 ? btnText.paintedWidth * 1.25 : defaultWidth)
           : 0
    height: 76
    text: qsTr("Next")

    property int backgroundRadius: 1
    property real defaultWidth: 155
    property bool boldText: true
    property real textPixelSize: 28
    property color backgroundColor: "transparent"
    property color pressedColor: AppStyle.foreground
    property color borderColor: AppStyle.foreground
    property real textRotation: 0

    contentItem: Item {
        implicitWidth: 155
        implicitHeight: 76

        Text {
            id: btnText
            anchors.fill: parent
            verticalAlignment: Text.AlignVCenter
            horizontalAlignment: Text.AlignHCenter
            wrapMode: Text.WordWrap
            text: control.text
            rotation: control.textRotation
            color: AppStyle.textColor
            font {
                pixelSize: control.textPixelSize
                bold: boldText
            }
        }
    }

    background: Rectangle {
        implicitWidth: 155
        implicitHeight: 76
        radius: control.backgroundRadius
        border.width: 1
        border.color: control.borderColor
        color: control.pressed ? control.pressedColor : control.backgroundColor
    }

    onClicked: {
        console.log("Clicked: " + control.text)
    }
}
