// Copyright 3D Control Systems, Inc. All Rights Reserved 2017-2019.
// Built in San Francisco.

// This software is distributed under a commercial license for personal,
// educational, corporate or any other use.
// The software as a whole or any parts of it is prohibited for distribution or
// use without obtaining a license from 3D Control Systems, Inc.

// All software licenses are subject to the 3DPrinterOS terms of use
// (available at https://www.3dprinteros.com/terms-and-conditions/),
// and privacy policy (available at https://www.3dprinteros.com/privacy-policy/)

import QtQuick 2.7
import AppStyle 1.0

/*
    AbstractMessageDialog - base item for creating message dialogs layers.
    Has dynamic body height
    impotant properties:
        buttonsSection - reference to bottom of dialog (buttons)

    Look at ConfirmDialog.qml MessageDialog.qml for example of use
*/

Item {
    id: msgDialogRoot
//    anchors.centerIn: rootItem
    width: AppStyle.rootItemWidth
    height: AppStyle.rootItemHeight
    visible: true
    property color titleColor: AppStyle.foreground
    property string titleText: qsTr("Info")
    property real defaultBodyHeight: 150
    property real buttonsSectionHeight: 120
    readonly property real maxBodyHeight: AppStyle.rootItemHeight - buttonsSectionHeight - titleRect.height
    readonly property real bodyHeight: msgText.paintedHeight > defaultBodyHeight
                                       ? (msgText.paintedHeight > maxBodyHeight ? maxBodyHeight : msgText.paintedHeight)
                                       : defaultBodyHeight


    property real dialogWidth: 500
    property real dialogHeight: bodyHeight + buttonsSectionHeight + titleRect.height
    property string msg: qsTr("Some info text to inform user")
    default property alias buttonsSection: buttonsSectionPlace.data

    MouseArea {
        anchors.fill: parent
    }

    Rectangle {
        id: background
        anchors.fill: parent
        color: "black"
        opacity: 0.5
    }

    Rectangle {
        id: dialogRoot
        width: dialogWidth
        height: dialogHeight
        color: AppStyle.background
        opacity: 1.0
        anchors.centerIn: parent

//        border {
//            color: "white"
//            width: 1
//        }

        Rectangle {
            id: titleRect
            anchors {
                top: dialogRoot.top
                right: dialogRoot.right
                left: dialogRoot.left
                margins: 1
            }

            height: 45
            color: titleColor

            Text {
                id: titleTextItem
                anchors.centerIn: parent
                color: AppStyle.textColor
                font.pixelSize: parent.height * 0.55
                text: titleText
            }
        }

        Flickable {
            id: winBody
            contentHeight: msgText.paintedHeight
            contentWidth: msgDialogRoot.dialogWidth
            anchors {
                top: titleRect.bottom
                right: parent.right
                left: parent.left
            }
            height: bodyHeight
            interactive: msgText.paintedHeight > maxBodyHeight
            clip: true

            Item {
                id: flickBody
                width: msgDialogRoot.dialogWidth
                height: msgText.paintedHeight > msgDialogRoot.bodyHeight ? msgText.paintedHeight : msgDialogRoot.bodyHeight

                Text {
                    id: msgText
                    anchors.fill: parent
                    color: AppStyle.textColor
                    text: msgDialogRoot.msg
                    horizontalAlignment: Text.AlignHCenter
                    verticalAlignment: Text.AlignVCenter
                    wrapMode: Text.WordWrap
                    font.pixelSize: 30
                }
            }
        }

        Item {
            id: buttonsSectionPlace
            anchors {
                top: winBody.bottom
                bottom: parent.bottom
                left: parent.left
                right: parent.right
                margins: 30
//                bottomMargin: 30
//                leftMargin: 30
//                rightMargin: 30
            }
        }
    }
}
