// Copyright 3D Control Systems, Inc. All Rights Reserved 2017-2019.
// Built in San Francisco.

// This software is distributed under a commercial license for personal,
// educational, corporate or any other use.
// The software as a whole or any parts of it is prohibited for distribution or
// use without obtaining a license from 3D Control Systems, Inc.

// All software licenses are subject to the 3DPrinterOS terms of use
// (available at https://www.3dprinteros.com/terms-and-conditions/),
// and privacy policy (available at https://www.3dprinteros.com/privacy-policy/)

import QtQuick 2.0
import AppControls 1.0
import AppStyle 1.0

Rectangle {
    id: busyLayer
    color: "black"
    opacity: 0.5
    z: 90
    width: AppStyle.rootItemWidth
    height: AppStyle.rootItemHeight
    visible: false
    anchors {
        centerIn: parent
    }

    function show() {
        busyLayer.visible = true
    }

    function hide() {
        busyLayer.visible = false
    }

    AppBusyIndicator {
        anchors.centerIn: parent
        width: Math.min(parent.width, parent.height) * 0.25
        height: Math.min(parent.width, parent.height) * 0.25
        running: parent.visible
    }

    MouseArea {
        anchors.fill: parent
    }
}
