import QtQuick 2.7
import QtQuick.Controls 2.4
import AppStyle 1.0
import AppViews 1.0

AbstactPage {

    signal gcodeResponse(string line, bool success)

    onGcodeResponse: {
        var output =
        consoleOutputText.text += line + "\n"
    }

    Component.onCompleted: {
        rootItem.hideHead()
        printerModel.localModeOn()
        printerModel.enableResponseCallbacks()
        printerModel.onOn_responseCallback.connect(gcodeResponse)
    }

    Component.onDestruction: {
        rootItem.showHead()
        printerModel.localModeOff()
        printerModel.disableResponseCallbacks()
        printerModel.onOn_responseCallback.disconnect(gcodeResponse)
    }

    Connections {
        target: rootItem
        onKeyPressed: {
            if (key === '\b') {
                consoleTextField.remove(consoleTextField.cursorPosition - 1, consoleTextField.cursorPosition)
                return
            }
            consoleTextField.insert(consoleTextField.cursorPosition, key)
        }
        onEnterPressed: {
            consoleTextField.accepted()
            consoleTextField.focus = false
        }
    }

    pageBody: Item {
        anchors.fill: parent

        ScrollView {
            id: consoleScrollView
            anchors {
                top: parent.top
                left: parent.left
                right: parent.right
                bottom: consoleTextField.top
                bottomMargin: AppStyle.defaultMargin * 0.5
            }

            ScrollBar.vertical: ScrollBar {
                id: scroll
                policy: ScrollBar.AlwaysOn
                visible: true
                parent: consoleScrollView
                interactive: true
                anchors {
                    top: parent.top
                    left: parent.right
                    bottom: parent.bottom
                }

                contentItem: Rectangle {
                    implicitWidth: 7
                    implicitHeight: 100
                    color: scroll.pressed ? AppStyle.textColor : AppStyle.foreground
                }
            }

            TextArea {
                id: consoleOutputText
                readOnly: true
                wrapMode: Text.WordWrap
                color: AppStyle.textColor
            }
        }

        TextField {
            id: consoleTextField
            anchors {
                left: parent.left
                right: parent.right
                bottom: parent.bottom
            }

            onPressed: {
                rootItem.showKeyboard()
            }

            onAccepted: {
                if (consoleTextField.text === "") {
                    return
                }
                console.log(consoleTextField)
                printerModel.executeGcodeLine(consoleTextField.text)
                consoleTextField.text = ""
            }
        }
    }

    footer {
        visible: !rootItem.keyboardVisible()
        height: rootItem.keyboardVisible() ? 0 : AppStyle.footerHeight
        nextBtnVisible: false
        onBackClicked: {
            rootItem.back()
        }
    }
}
