import QtQuick 2.7
import QtQuick.Controls 2.4
import AppStyle 1.0
import AppViews 1.0

ListPage {
    id: licListPage

    ListModel {
        id: licenseListModel
        ListElement {
            name: 'Qt5'
            url: "https://www.qt.io/"
            licensePath: "licenses/LGPLv3.txt"
            license: "LGPLv3"
        }

        ListElement {
            name: 'PySide2'
            url: "http://wiki.qt.io/PySide2"
            licensePath: "licenses/LGPLv3.txt"
            license: "LGPLv3"
        }

        ListElement {
            name: 'qqr.js'
            url: "https://github.com/M4rtinK/qqr.js"
            licensePath: "licenses/qqrjs.txt"
            license: "LGPLv3"
        }

        ListElement {
            name: 'qml-keyboard'
            url: "https://github.com/MishkaRogachev/qml-keyboard"
            licensePath: "licenses/LGPLv3.txt"
            license: "LGPLv3"
        }

        ListElement {
            name: 'simplejson'
            url: "https://github.com/simplejson/simplejson"
            licensePath: "licenses/simplejson.txt"
            license: "MIT"
        }

        ListElement {
            name: 'pyusb'
            url: "https://github.com/pyusb/pyusb"
            licensePath: "licenses/LGPLv3.txt"
            license: "LGPLv3"
        }

        ListElement {
            name: 'pyserial'
            url: "https://github.com/pyserial/pyserial"
            licensePath: "licenses/pyserial.txt"
            license: "BSD"
        }

        ListElement {
            name: 'opencv'
            url: "https://github.com/opencv/opencv"
            licensePath: "licenses/opencv.txt"
            license: "BSD clause 3"
        }

        ListElement {
            name: 'numpy'
            url: "https://github.com/numpy/numpy"
            licensePath: "licenses/numpy.txt"
            license: "BSD 3-Clause Revised"
        }

        ListElement {
            name: 'python-networkmanager'
            url: "https://github.com/seveas/python-networkmanager"
            licensePath: "licenses/python-nm.txt"
            license: "zlib"
        }

        ListElement {
            name: 'idna'
            url: "https://github.com/kjd/idna"
            licensePath: "licenses/idna.txt"
            license: "BSD-like"
        }

        ListElement {
            name: 'certifi'
            url: "https://certifi.io"
            licensePath: "licenses/certifi.txt"
            license: "MPL"
        }

        ListElement {
            name: 'chardet'
            url: "https://github.com/chardet/chardet"
            licensePath: "licenses/LGPLv2.1.txt"
            license: "LGPLv2.1"
        }

        ListElement {
            name: 'requests'
            url: "https://requests.kennethreitz.org"
            licensePath: "licenses/requests.txt"
            license: "Apache 2.0"
        }

        ListElement {
            name: 'dbus'
            url: "https://github.com/freedesktop/dbus-python"
            licensePath: "licenses/dbus.txt"
            license: "custom license"
        }
    }

    listViewItem {
        model: licenseListModel
        delegate: Rectangle {
            id: licenseDelegate
            width: listViewItem.width
            height: 64
            color: licenseDelegateMa.pressed ? AppStyle.foreground : "transparent"
            border {
                color: AppStyle.foreground
                width: 1
            }

            Column {
                id: licenseDesc
                anchors {
                    left: parent.left
                    leftMargin: 15
                    right: licenseNameItem.left
                    verticalCenter: parent.verticalCenter
                }

                Text {
                    id: nameText
                    text: model.name
                    color: AppStyle.textColor
                }

                Text {
                    id: utlText
                    text: model.url
                    color: AppStyle.textColor
                }
            }

            Item {
                id: licenseNameItem
                width: licenseNameText.width
                anchors {
                    top: parent.top
                    right: parent.right
                    rightMargin: 15
                    bottom: parent.bottom
                }

                Text {
                    id: licenseNameText
                    text: model.license
                    anchors.centerIn: parent
                    color: AppStyle.textColor
                }
            }

            MouseArea {
                id: licenseDelegateMa
                anchors.fill: parent
                onClicked: {
                    rootItem.pushView("LicenseView.qml", {filePath: model.licensePath})
                }
            }
        }
    }

    footer {
        nextBtnVisible: false
        onBackClicked: {
            rootItem.back()
        }
    }
}
