// Copyright 3D Control Systems, Inc. All Rights Reserved 2017-2019.
// Built in San Francisco.

// This software is distributed under a commercial license for personal,
// educational, corporate or any other use.
// The software as a whole or any parts of it is prohibited for distribution or
// use without obtaining a license from 3D Control Systems, Inc.

// All software licenses are subject to the 3DPrinterOS terms of use
// (available at https://www.3dprinteros.com/terms-and-conditions/),
// and privacy policy (available at https://www.3dprinteros.com/privacy-policy/)

import QtQuick 2.0
import AppControls 1.0
import AppDialogs 1.0
import AppStyle 1.0
import AppViews 1.0
import "constants.js" as Constants


AbstactPage {
    id: settingsView

    pageBody: Item {
        anchors.fill: parent
        Grid {
            id: settingsGrid
            spacing: AppStyle.defaultMargin * 0.6
            anchors.centerIn: parent
            rows: 3
            columns: 3
            columnSpacing: AppStyle.defaultMargin * 0.6
            rowSpacing: AppStyle.defaultMargin * 0.6

            property real btnWidth: AppStyle.settingsMenuItemWidth
            property real btnHeight: AppStyle.settingsMenuItemHeight


            TextButton {
                width: settingsGrid.btnWidth
                height: settingsGrid.btnHeight
                text: qsTr("Network")
                onClicked: {
                    rootItem.pushView("NetworkMenu.qml")
                }
            }

            TextButton {
                width: settingsGrid.btnWidth
                height: settingsGrid.btnHeight
                text: qsTr("Advanced")
                onClicked: {
                    rootItem.pushView("AdvancedView.qml")
                }
            }

            TextButton {
                width: settingsGrid.btnWidth
                height: settingsGrid.btnHeight
                text: qsTr("About")
                onClicked: {
                    rootItem.pushView("AboutView.qml")
                }
            }

            TextButton {
                width: settingsGrid.btnWidth
                height: settingsGrid.btnHeight
                text: qsTr("Joystick")
                onClicked: {
                    if (coreModel.state === Constants.States.PRINTING || coreModel.state === Constants.States.PAUSED) {
                        rootItem.showMessageDialog(Constants.MessageTypes.INFO, qsTr("Can't enter joystick while printing"), "OK")
                        return
                    }

                    if (coreModel.state === Constants.States.REGISTRATION) {
                        rootItem.showMessageDialog(Constants.MessageTypes.INFO, qsTr("Can't enter joystck while in registeration mode"), "OK")
                        return
                    }

                    if (coreModel.state === Constants.States.CONNECTING) {
                        return
                    }

                    rootItem.pushView("JoystickView.qml")
                }
            }

            TextButton {
                width: settingsGrid.btnWidth
                height: settingsGrid.btnHeight
                text: qsTr("Filaments")
                onClicked: {
                    if (coreModel.state === Constants.States.PRINTING || coreModel.state === Constants.States.PAUSED) {
                        rootItem.showMessageDialog(Constants.MessageTypes.INFO, qsTr("Can't enter filaments menu while printing"), "OK")
                        return
                    }

                    if (coreModel.state === Constants.States.REGISTRATION) {
                        rootItem.showMessageDialog(Constants.MessageTypes.INFO, qsTr("Can't enter filaments menu while in registeration mode"), "OK")
                        return
                    }

                    if (coreModel.state === Constants.States.CONNECTING) {
                        return
                    }

                    rootItem.pushView("FilamentsMenu.qml")
                }
            }

            TextButton {
                width: settingsGrid.btnWidth
                height: settingsGrid.btnHeight
                text: qsTr("Cloud")
                onClicked: {
                    rootItem.pushView("CloudSettingsView.qml")
                }
            }
        }
    }

    footer {
        nextBtnVisible: false
        onBackClicked: {
            rootItem.hideSetting()

        }
    }
}

