# 3DPrinterOS API2 local control HTTP API calls v0.1

Technical details:

Requests need to have one of the next content types for sending parameters:
```
Content-Type: application/x-www-form-urlencoded
Content-Type: application/json
```


Local environment endpoint: `http://127.0.0.1:8008/api2`

Remote environment endpoint: `http://<3dprinteros_client_host_ip>:8008/api2`

   **NOTE: The remote environment endpoint requires cookie with a token value**

   Example:
   ```
   curl http://<3dprinteros_client_ip>:8008/api2/full_report -H "cookie:token=<token_from_user_login>"
   ```


**1. User login**
```
/login
POST
Content-Type: application/x-www-form-urlencoded:
   login - text
   password - text
   
Content-Type: application/json:
   { “login”: “<user-email>”, “password”: “<password>”}
```
Response:

Success:
```
{ “auth_token”: <text> }
 ```
Fail:

```
{ “error”: { “message”: <text>, “code”: <int> }
```


**2. Full report**
```
/full_report
GET
```
Response:

Success: 
```
{"printers": {
"<VID_PID_serialnumber>": {
"report": {
   "state": "ready", "percent": 0.0, "temps": [0.0, 0.0], "target_temps": [0.0, 0.0]
}, 
"errors": []
},
… 
},
"update_available": false, "update_downloaded": false}
```
Fail: 
```
{ “error”: { “message”: <text>, “code”: <int> }
```



**3. Static values**
```
/static_values
GET
```

Response:

Success: 
```
{"version": "<software_version>", "cloud_url": "cloud.3dprinteros.com", "style_name": "style", "show_your_account_button": true}
```

Fail: 
```
{ “error”: { “message”: <text>, “code”: <int> }
```

**4.Settings**
```
/settings
GET

POST
Content-Type: application/json:
   {“<setting_to_update>”: <new_value> }
```

Response:

Success: 
```
{ <settings_json>}
```
Fail: 
```
{ “error”: { “message”: <text>, “code”: <int> }
```

**5. Send printer command**
```
/
POST
Content-Type: application/x-www-form-urlencoded:
   printer_id - VID_PID_serialnumber
   command - text (pause, cancel, etc.)

Content-Type: application/json:
   { 
      “printer_id”: “<VID_PID_serialnumber>”,
      “command”: “<command_text>”,
      "payload": <any>  // optional
   }
```

Response:

Success:
```
{"number": -1, "result": true}

```

Fail: 
```
{"error": {"message": "Command failure", "code": -1, "ack": {"number": -1, "result": false}}}
```

# List of avalable commands with payload
```
# Cancel current printer job
command: cancel_locally

# Close and restart printer interface
command: close
 
# Disable/enable local mode
command: disable_local_mode
command: enable_local_mode, payload: [start_timeout_thread: <class 'bool'>]

# Report problem to cloud
command: report_problem, payload: [problem_description: <class 'str'>]

# TODO
command: request_printer_groups_selection, payload: [groups: typing.List[dict]]

# Rename printer
command: request_printer_rename, payload: [name: <class 'str'>]

# TODO
command: request_printer_type_selection, payload: [printer_profile_or_alias: typing.Union[str, dict]]

# Set up flag to reset printer type in next command request. (For offline mode it will reset printer type by reloading module )
command: request_reset_printer_type

# Restart camera module
command: restart_camera, payload: [token: <class 'str'>]

# Add bed clear to request
command: send_bed_clear

# Set versbose logging for USB
command: set_verbose, payload: [verbose_enabled: <class 'bool'>]

# Send a request to start a job by id
command: start_job_by_id, payload: [job_id: str]

# Send a request to start next job in queue
command: start_next_job

# Switch camera module by name
command: switch_camera, payload: [module: <class 'str'>]

# Turn off local mode and flushing callbacks
command: turn_off_local_mode

# Execute update command from server
command: update_software

# Start print with gcode file
command: gcodes, payload: [filepath: typing.Union[~AnyStr, _io.BytesIO], keep_file: <class 'bool'>]

# TODO
command: load_gcodes, payload: [gcodes: typing.Any]

# Pause running job
command: pause

# Resume running job
command: resume

# TODO
command: unbuffered_gcodes, payload: [gcodes: typing.Any]

# Add url for streaming in %APPDATA%/camera_urls.txt 
command: add_camera_url, payload: [url_to_add: str, retries_left: <class 'int'>]

# Reset printer interface
command: reset
```
