// Copyright 3D Control Systems, Inc. All Rights Reserved 2017-2019.
// Built in San Francisco.

// This software is distributed under a commercial license for personal,
// educational, corporate or any other use.
// The software as a whole or any parts of it is prohibited for distribution or
// use without obtaining a license from 3D Control Systems, Inc.

// All software licenses are subject to the 3DPrinterOS terms of use
// (available at https://www.3dprinteros.com/terms-and-conditions/),
// and privacy policy (available at https://www.3dprinteros.com/privacy-policy/)

import QtQuick 2.7
import AppDialogs 1.0
import AppStyle 1.0

RowTextAnim {
    property string loadSlotName: ""
    animSource: "gifs/filament-load-" + loadSlotName + "_final.gif"
    infoText: qsTr("Filament loading procedure started. Please place the filament in the dry box and push the filament through the lighted hole until the motor grips the filament.")
    property bool pushedNext: false
    property string gcodeToExecute: 'M98 P"0:/sys/filachangload/load/autoload' + loadSlotName + '.g"'

    Component.onCompleted: {
        if (gcodeToExecute !== "") {
            console.log(gcodeToExecute)
            printerModel.executeGcodeLine(gcodeToExecute)
        }
    }

    footer {
        visible: false
        backBtnVisible: false
        nextBtnVisible: false
        onVisibleChanged: {
            filamentWizardRoot.saveMaterialList()
            if (filamentWizardRoot.wizardType === FilamentWizard.WizardType.Load && !pushedNext) {
                pushedNext = true
                filamentWizardRoot.pushView("FilamentWait.qml", {
                                                "done": true,
                                                "slotName": loadSlotName
                                            })
            }
        }
    }
}
