// Copyright 3D Control Systems, Inc. All Rights Reserved 2017-2019.
// Built in San Francisco.

// This software is distributed under a commercial license for personal,
// educational, corporate or any other use.
// The software as a whole or any parts of it is prohibited for distribution or
// use without obtaining a license from 3D Control Systems, Inc.

// All software licenses are subject to the 3DPrinterOS terms of use
// (available at https://www.3dprinteros.com/terms-and-conditions/),
// and privacy policy (available at https://www.3dprinteros.com/privacy-policy/)

import QtQuick 2.7
import QtQuick.Controls 2.4
import AppStyle 1.0
import AppControls 1.0
import AppViews 1.0

AbstactPage {
    id: tempView
    property string msg: filamentWizardRoot.wizardType === FilamentWizard.WizardType.Unload
                         ? qsTr("Please set the unloading temperature for the filament and press 'Next'")
                         : qsTr("Please set the loading temperature for the filament and press 'Next'")
    property string currentTemp: ""

    Component.onCompleted: {
        currentTemp = filamentWizardRoot.getCurrentTemp()
    }

    pageBody: Item {
        anchors.fill: parent
        Column {
            spacing: AppStyle.theme.defaultMargin
            width: parent.width
            anchors {
                top: parent.top
                horizontalCenter: parent.horizontalCenter
            }

            Item {
                id: numFieldWrapper
                width: parent.width
                height: numberField.height

                Row {
                    anchors.centerIn: parent
                    AppNumberField {
                        id: numberField
                        height: 96
                        text: currentTemp
                        width: numFieldWrapper.width * 0.3
                        minValue: 0.1
                        maxValue: 360
                        onPressed: {
                            rootItem.showKeyboardNum()
                        }
                    }
                    Rectangle {
                        id: hint
                        height: numberField.height
                        width: hintText.width + hintText.height * 0.5
                        Text {
                            id: hintText
                            anchors.centerIn: parent
                            color: numberField.color
                            font.pixelSize: numberField.font.pixelSize
                            text: AppStyle.degreeSymbol + "C"
                        }
                    }
                }
            }

            Text {
                text: msg
                anchors.verticalCenterOffset: 75
                anchors.horizontalCenterOffset: 0
                width: parent.width
                verticalAlignment: Text.AlignVCenter
                horizontalAlignment: Text.AlignHCenter
                font.pixelSize: 25
                wrapMode: Text.WordWrap
                color: AppStyle.theme.textColor
            }
        }
    }

    footer {
        visible: !rootItem.keyboardVisible()
        nextBtnVisible: numberField.text !== ""
        onNextClicked: {
            rootItem.hideKeyboard()
            if (numberField.text === "") {
                return
            }
            numberField.validateField()
            filamentWizardRoot.saveLastTemp(numberField.text)
            filamentWizardRoot.pushView("HeatingInfo.qml", {"customTemp": numberField.text})
        }
        onBackClicked: {
            filamentWizardRoot.cancelWizard()
        }
    }
}
