// Copyright 3D Control Systems, Inc. All Rights Reserved 2017-2019.
// Built in San Francisco.

// This software is distributed under a commercial license for personal,
// educational, corporate or any other use.
// The software as a whole or any parts of it is prohibited for distribution or
// use without obtaining a license from 3D Control Systems, Inc.

// All software licenses are subject to the 3DPrinterOS terms of use
// (available at https://www.3dprinteros.com/terms-and-conditions/),
// and privacy policy (available at https://www.3dprinteros.com/privacy-policy/)

import QtQuick 2.0
import QRCode 1.0

import AppStyle 1.0
import AppControls 1.0
import AppDialogs 1.0

import "constants.js" as Constants

Item {
    id: tokenView
    objectName: Constants.States.REGISTRATION

    ConfirmDialog {
        id: confirmShutdown
        visible: false
        z: 50
        anchors {
            verticalCenterOffset: -AppStyle.theme.headHeight * 0.5
            centerIn: parent
        }
        msg: qsTr("Turn off machine")
        onYes: {
            rootItem.showBusy()
            coreModel.shutdown()
        }
    }

    Item {
        anchors.fill: parent
        visible: printerModel.token !== ""

        Item {
            id: infoItem
            width: parent.width * 0.65

            anchors {
                top: parent.top
                left: parent.left
                bottom: parent.bottom
            }

            Column {
                width: parent.width
                anchors {
                    verticalCenterOffset: -25
                    centerIn: parent
                }
                spacing: 20


                TextEdit {
                    id: tokenText
                    text: printerModel.token
                    readOnly: true
                    width: parent.width
                    horizontalAlignment: TextEdit.AlignHCenter
                    color: AppStyle.theme.textColor
                    font {
                        bold: true
                        pixelSize: 35
                    }
                    selectByMouse: true
                }

                Item {
                    width: parent.width
                    height: qrCode.height

                    Rectangle {
                        anchors.centerIn: parent
                        width : 170
                        height : 170
                        visible: tokenText.text !== ""
                        QRCode {
                            id: qrCode
                            anchors.centerIn: parent
                            width : 150
                            height : 150
                            visible: tokenText.text !== ""
                            value : tokenText.text
                        }
                    }
                }

                Text {
                    id: infoText
                    width: parent.width
                    wrapMode: Text.WordWrap
                    color: AppStyle.theme.textColor
                    font.pixelSize: 22
                    horizontalAlignment: Text.AlignHCenter
                    text: printerModel.token ? qsTr("Please register this code at\n %1").arg(coreModel.cloudURL) : qsTr("Connecting...") //TODO add variable for current cloud URL
                }
            }
        }

        Item {
            id: ctrlColumn
            anchors {
                top: parent.top
                right: parent.right
                left: infoItem.right
                bottom: parent.bottom
            }

            Column {
                id: buttonsColumn
                spacing: printLocalBtn.height * 0.5
                width: parent.width * 0.9
                anchors {
                    left: parent.left
                    right: parent.right
                    bottom: parent.bottom
                }

                TextButton {
                    id: printLocalBtn
                    width: parent.width
                    text: qsTr("Offline mode")
                    onClicked: {
                        console.log("")
                        coreModel.toggleOfflineMode()
                        rootItem.showBusy()
                    }
                }

                TextButton {
                    id: shutDownBtn
                    width: parent.width
                    text: qsTr("Shutdown")
                    onClicked: {
                        confirmShutdown.visible = true
                    }
                }
            }
        }
    }

    Text {
        id: connectingText
        anchors {
            left: parent.left
            right: parent.right
            bottom: parent.bottom
        }
        color: AppStyle.theme.textColor
        visible: printerModel.token === ""
        font.pixelSize: 28
        horizontalAlignment: Text.AlignHCenter
        text: qsTr("Connecting...")
    }
}
