// Copyright 3D Control Systems, Inc. All Rights Reserved 2017-2019.
// Built in San Francisco.

// This software is distributed under a commercial license for personal,
// educational, corporate or any other use.
// The software as a whole or any parts of it is prohibited for distribution or
// use without obtaining a license from 3D Control Systems, Inc.

// All software licenses are subject to the 3DPrinterOS terms of use
// (available at https://www.3dprinteros.com/terms-and-conditions/),
// and privacy policy (available at https://www.3dprinteros.com/privacy-policy/)

import QtQuick 2.7
import QtQuick.Controls 2.4
import AppStyle 1.0

Row {
    id: control
    height: 64

    property real minValue: 0.0
    property real maxValue: 300
    property real stepSize: 1
    property real value: 0.0
    spacing: -1

    function validate() {
        value = (value < minValue ? minValue : (value > maxValue ? maxValue : value))
        validated()
    }

    signal validated()
    property string unitText: ""

    TextButton {
        text: "-"
        width: 65
        height: 65
        backgroundRadius: 0
        borderColor: AppStyle.theme.foreground
        onClicked: {
            control.value -= stepSize
            validate()
        }
    }

    Rectangle {
        id: valueRect
        width: 70
        height: 65
        color: "transparent"
        border.width: 1
        border.color: AppStyle.theme.foreground

        Text {
            id: valueText
            font.pixelSize: Math.min(parent.height, parent.width) * 0.4
            clip: true
            anchors.centerIn: parent
            color: AppStyle.theme.textColor
            text: qsTr("%1%2").arg(value).arg(unitText)
        }
    }

    TextButton {
        text: "+"
        backgroundRadius: 0
        borderColor: AppStyle.theme.foreground
        width: 65
        height: 65
        onClicked: {
            control.value += stepSize
            validate()
        }
    }
}
