// Copyright 3D Control Systems, Inc. All Rights Reserved 2017-2019.
// Built in San Francisco.

// This software is distributed under a commercial license for personal,
// educational, corporate or any other use.
// The software as a whole or any parts of it is prohibited for distribution or
// use without obtaining a license from 3D Control Systems, Inc.

// All software licenses are subject to the 3DPrinterOS terms of use
// (available at https://www.3dprinteros.com/terms-and-conditions/),
// and privacy policy (available at https://www.3dprinteros.com/privacy-policy/)

import QtQuick 2.7
import QtQuick.Controls 2.4
import AppStyle 1.0

Button {
    id: control
    width: 200
    height: 200
    text: "test test"
    font.bold: true
    property string imgSrc: "../img/settings-menu-icon-big.png"
    property color backgroundColor: AppStyle.theme.warningTitleBackgraound

    contentItem: Item {
        Image {
            id: img
            sourceSize.width: 160
            sourceSize.height: 100
            asynchronous: true
            anchors {
                verticalCenterOffset: -30
                horizontalCenterOffset: 0
                centerIn: parent
            }
            source: imgSrc
        }

        Text {
            text: control.text
            verticalAlignment: Text.AlignBottom
            horizontalAlignment: Text.AlignHCenter
            width: control.width * 0.6
            anchors {
                top: img.bottom
                topMargin: 20
                horizontalCenter: parent.horizontalCenter
            }
            font {
                bold: true
                pixelSize: 20
            }
            wrapMode: Text.WordWrap
        }
    }

    background: Rectangle {
        implicitWidth: 200
        implicitHeight: 200
        border.width: 0
        color: control.pressed ? AppStyle.theme.pressedColor : control.backgroundColor
    }
}
