import QtQuick 2.7
import QtQuick.Controls 2.2
import QtQuick.Layouts 1.12
import AppStyle 1.0
import AppControls 1.0
import AppViews 1.0
import Keyboard 1.0

AbstactPage {
    id: configItem

    pageBody: ScrollView {
        id: configScrollView
        anchors.fill: parent
        clip: true

        /**
         * @param type [Qt.Horizontal, Qt.Vertical]
         * @param ratio 0.0 to 1.0
         */
        function scrollTo(type, ratio) {
            var scrollFunc = function (bar, ratio) {
                bar.setPosition(ratio - bar.size/2)
            }
            switch(type) {
            case Qt.Horizontal:
                scrollFunc(root.hScrollBar, ratio)
                break;
            case Qt.Vertical:
                scrollFunc(root.vScrollBar, ratio)
                break;
            }
        }

        ScrollBar.vertical: ScrollBar {
            id: scroll
            policy: ScrollBar.AlwaysOn
            visible: true
            parent: configScrollView
            interactive: true
            anchors {
                top: parent.top
                right: parent.right
                bottom: parent.bottom
            }

            contentItem: Rectangle {
                implicitWidth: 7
                implicitHeight: 100
                color: scroll.pressed ? AppStyle.theme.textColor : AppStyle.theme.foreground
            }
        }

        RowLayout {
            id: textRow
            anchors.fill: parent
            clip: true
            spacing: 15

            ListView {
                Layout.preferredWidth: 30
                Layout.fillHeight: true
                model: configText.text.split(/\n/g)
                delegate:  Text {
                    font.pixelSize: 21
                    color: AppStyle.theme.configLineNumberColor
                    text: index + 1
                }
            }
            TextArea {
                id: configText
                color: AppStyle.theme.textColor
                font.pixelSize: 21
                Layout.fillWidth: true
                Layout.fillHeight: true
                onFocusChanged: {
                    if (focus) {
                        rootItem.showKeyboard()
                       // itemRatio = configText.cursorRectangle.y / configScrollView.contentHeight;
                       // configScrollView.scrollTo(Qt.Vertical, itemRatio)
                    }
                }

            }
        }
    }

    Component.onCompleted: {
        rootItem.hideHead()
        configText.text = coreModel.configToEdit
    }
    Connections {
        target: rootItem.keyboardItem
        function onKeyClicked(key) {
            if (key === '\b') {
                configText.remove(configText.cursorPosition - 1, configText.cursorPosition)
                return
            }
            configText.insert(configText.cursorPosition, key)
        }
        function onEnterClicked() {
            configText.focus = false
            rootItem.hideKeyboard()
        }
        function onHideClicked() {
            configText.focus = false
            rootItem.hideKeyboard()
        }
    }

    footer {
        nextBtnVisible: true
        nextBtnText: qsTr("Save")
        visible: !rootItem.keyboardVisible()
        height: rootItem.keyboardVisible() ? 0 : AppStyle.theme.footerHeight

        onBackClicked: {
            rootItem.showHead()
            rootItem.back()
        }
        onNextClicked: {
            coreModel.validateAndSaveConfig(configText.text)
        }
    }
}
