import QtQuick 2.7
import QtQuick.Controls 2.4
import AppControls 1.0
import AppViews 1.0
import AppStyle 1.0
import AppDialogs 1.0

AbstactPage {
    id: selectSlotPage
    property string titleText: filamentWizardRoot.wizardType === FilamentWizard.WizardType.Load
                               ? qsTr("Select the slot to load material:")
                               : qsTr("Select the slot to unload material:")

    ConfirmDialog {
        id: unloadConfirm
        z: 105
        anchors {
            verticalCenterOffset: AppStyle.theme.headHeight * 0.6
            centerIn: parent
        }
        visible: false
        titleText: qsTr("Info")
        msg: slotGroup.checkedButton ? qsTr("AutoUnload Slot " + slotGroup.checkedButton.text + ", Are you sure?") : ""
        yesText: qsTr("Yes")
        noText: qsTr("No")
        onYes: {
            var index = parseInt(slotGroup.checkedButton.text) - 1
            filamentWizardRoot.materialList[index] = ""
            filamentWizardRoot.pushView("FilamentWait.qml", {
                                            "gcodeToExecute": 'M98 P"0:/sys/filachangload/unload/autounload' + slotGroup.checkedButton.text + '.g"',
                                            "slotName": slotGroup.checkedButton.text
                                        })
        }
    }

    ConfirmDialog {
        id: loadConfirm
        z: 105
        anchors {
            verticalCenterOffset: AppStyle.theme.headHeight * 0.6
            centerIn: parent
        }
        visible: false
        titleText: qsTr("Info")
        msg: slotGroup.checkedButton ? qsTr("Autoload Slot " + slotGroup.checkedButton.text + ", Are you sure?") : ""
        yesText: qsTr("Yes")
        noText: qsTr("No")
        onYes: {
            filamentWizardRoot.pushView("LoadConfirm.qml", {
                                            "loadSlotName": slotGroup.checkedButton.text
                                        })
        }
    }

    pageBody: Item {
        id: body
        anchors.fill: parent
        property var defaultMaterials: ["DYNAMIDE® GF", "DYNAMIDE® CF", "DYNAMIDE® PA", "DYNAMIDE® ASA", "DYNAMIDE® Breakaway", "Other Material"]
        property var supportMaterials: ["DYNAMIDE® Breakaway"]

        Item {
            id: selectFilamentItem
            anchors.fill: parent
            visible: false

            property var availableMaterials: body.defaultMaterials

            Grid {
                id: settingsGrid
                spacing: AppStyle.theme.defaultMargin * 0.6
                anchors.centerIn: parent
                rows: 2
                columns: 3
                columnSpacing: AppStyle.theme.defaultMargin * 0.6
                rowSpacing: AppStyle.theme.defaultMargin * 0.6

                property real btnWidth: AppStyle.theme.settingsMenuItemWidth
                property real btnHeight: AppStyle.theme.settingsMenuItemHeight

                ButtonGroup { id: filamentGroup }

                Repeater {
                    model: selectFilamentItem.availableMaterials

                    RadioFilamentSlot {
                        text: modelData
                        width: settingsGrid.btnWidth * 0.9
                        height: settingsGrid.btnHeight * 0.9
                        fontPixelSize: height * 0.17
                        ButtonGroup.group: filamentGroup
                    }
                }
            }
        }

        Item {
            id: selectSlotItem
            anchors.fill: parent

            Text {
                id: titleItem
                anchors {
                    top: parent.top
                    horizontalCenter: parent.horizontalCenter
                }
                font.pixelSize: 23
                font.bold: true
                text: titleText
                color: AppStyle.theme.textColor
            }

            Row {
                id: slotRow
                anchors {
                    top: titleItem.bottom
                    horizontalCenter: parent.horizontalCenter
                }
                spacing: 105

                ButtonGroup { id: slotGroup }

                Column {
                    id: modelMatCol
                    spacing: 10

                    Text {
                        width: matSlotRow.width
                        horizontalAlignment: Text.AlignHCenter
                        font.pixelSize: 23
                        text: qsTr("Model Material")
                        color: AppStyle.theme.textColor
                    }

                    Row {
                        id: matSlotRow
                        spacing: -2

                        RadioFilamentSlot {
                            id: slot1
                            text: "1"
                            descText: filamentWizardRoot.materialList[0]
                            ButtonGroup.group: slotGroup
                        }
                        RadioFilamentSlot {
                            id: slot2
                            text: "2"
                            descText: filamentWizardRoot.materialList[1]
                            ButtonGroup.group: slotGroup
                        }
                    }
                }

                Column {
                    id: supMatCol
                    spacing: 10

                    Text {
                        width: supSlotRow.width
                        horizontalAlignment: Text.AlignHCenter
                        font.pixelSize: 23
                        text: qsTr("Support Material")
                        color: AppStyle.theme.textColor
                    }

                    Row {
                        id: supSlotRow
                        spacing: -2

                        RadioFilamentSlot {
                            id: slot3
                            text: "3"
                            descText: filamentWizardRoot.materialList[2]
                            ButtonGroup.group: slotGroup
                        }

                        RadioFilamentSlot {
                            id: slot4
                            text: "4"
                            descText: filamentWizardRoot.materialList[3]
                            ButtonGroup.group: slotGroup
                        }
                    }
                }
            }
        }
    }

    function showSelectFilamentType() {
        selectFilamentItem.visible = true
        selectSlotItem.visible = false

        if (slot3.checked || slot4.checked) {
            selectFilamentItem.availableMaterials = body.supportMaterials
            return
        } else if (slot1.descText !== "") {
            selectFilamentItem.availableMaterials = [slot1.descText]
            return
        } else if (slot2.descText !== "") {
            selectFilamentItem.availableMaterials = [slot2.descText]
            return
        } else {
            selectFilamentItem.availableMaterials = body.defaultMaterials
        }
    }

    function hideSelectFilamentType() {
        selectFilamentItem.visible = false
        selectSlotItem.visible = true
    }

    function hideBlockSelectFilamentType() {
        selectFilamentItem.visible = false
        selectSlotItem.visible = true
        slot1.enabled = false
        slot2.enabled = false
        slot3.enabled = false
        slot4.enabled = false
    }

    footer {
        visible: !unloadConfirm.visible && !loadConfirm.visible
        nextBtnText: filamentWizardRoot.wizardType === FilamentWizard.WizardType.Load
                     && slotGroup.checkedButton && slotGroup.checkedButton.descText.length !== 0
                     ? "Load" : "Next"
        nextBtnVisible: !loadConfirm.visible && !unloadConfirm.visible && (selectSlotItem.visible && slotGroup.checkedButton !== null) || (selectFilamentItem.visible && filamentGroup.checkedButton !== null)
        backBtnVisible: !loadConfirm.visible && !unloadConfirm.visible
        onBackClicked: {
            if (selectFilamentItem.visible) {
                hideSelectFilamentType()
                return
            }
            filamentWizardRoot.cancelWizard()
        }
        onNextClicked: {
            if (filamentWizardRoot.wizardType === FilamentWizard.WizardType.Load) {
                if (selectFilamentItem.visible) {
                    hideBlockSelectFilamentType()
                    var index = parseInt(slotGroup.checkedButton.text) - 1
                    filamentWizardRoot.materialList[index] = filamentGroup.checkedButton.text
                    slotGroup.checkedButton.descText = filamentGroup.checkedButton.text
                    return
                }

                if (slotGroup.checkedButton.descText.length === 0 && !selectFilamentItem.visible) {
                    showSelectFilamentType()
                    return
                }

                loadConfirm.visible = true
            }

            if (filamentWizardRoot.wizardType === FilamentWizard.WizardType.Unload) {
                unloadConfirm.visible = true
            }
        }
    }
}
