// Copyright 3D Control Systems, Inc. All Rights Reserved 2017-2019.
// Built in San Francisco.

// This software is distributed under a commercial license for personal,
// educational, corporate or any other use.
// The software as a whole or any parts of it is prohibited for distribution or
// use without obtaining a license from 3D Control Systems, Inc.

// All software licenses are subject to the 3DPrinterOS terms of use
// (available at https://www.3dprinteros.com/terms-and-conditions/),
// and privacy policy (available at https://www.3dprinteros.com/privacy-policy/)

pragma Singleton
import QtQuick 2.7

/*
    This file contains read only properties that could be repeated in many qml files
*/

Item {
    // symbols
    readonly property string degreeSymbol: "\u00B0"
    readonly property string checkSymbol: "\u2713"


    property var theme: defaultTheme

    property var availableThemes: {
       "default": defaultTheme,
       "loop3d": loop3dTheme,
       "loop3dplus": loop3dPlusTheme
    }

    Component.onCompleted: {
        if (availableThemes.hasOwnProperty(coreModel.theme)) {
            console.log("Using theme: " + coreModel.theme)
            theme = availableThemes[coreModel.theme]
        } else {
            console.log(coreModel.theme + " is not supported. Using default theme")
        }
        coreModel.setAppFont(theme.fontFamily)
    }

    Theme {
        id: defaultTheme
    }

    Theme {
        id: loop3dTheme
        name: "loop3d"
        imgDir: "AppStyle/loop3d/img/"

        e0TempText: "Head"
        bedTempText: "Bed"

        logoImgSource: imgDir + "logo_loop_3d.svg"
        fontFamily: "Lato"
        secondFontFamily: "Audiowide"

        // colors
        foreground: "#31AFFD"
        statusTextColor: foreground
        listBorderColor: foreground

        // menus
        joystickMenu: "JoystickView.qml"
        filamentWizzardMenu: "FilamentsMenu.qml"

        textBtnBgRadius: 1
        textBtnUpperCase: false
        textBtnPressedColor: foreground
    }

    Theme {
        id: loop3dPlusTheme
        name: "loop3dPlus"
        imgDir: "AppStyle/loop3d/img/"

        e0TempText: "Printhead"
        bedTempText: "Bed"
        doubleTool: true
        logoImgSource: imgDir + "loop3d_logo.png"
        headLogoWidth: 278.4
        headLogoHeight: 44.6

        fontFamily: "Lato"
        secondFontFamily: "Audiowide"

        // colors
        foreground: "#53A2DA"
        statusTextColor: foreground
        // menus
        joystickMenu: "JoystickView.qml"
        filamentWizzardMenu: "FilamentsPlusMenu.qml"

        textBtnBgRadius: 1
        textBtnUpperCase: false
        textBtnPressedColor: foreground
    }
}
