// Copyright 3D Control Systems, Inc. All Rights Reserved 2017-2019.
// Built in San Francisco.

// This software is distributed under a commercial license for personal,
// educational, corporate or any other use.
// The software as a whole or any parts of it is prohibited for distribution or
// use without obtaining a license from 3D Control Systems, Inc.

// All software licenses are subject to the 3DPrinterOS terms of use
// (available at https://www.3dprinteros.com/terms-and-conditions/),
// and privacy policy (available at https://www.3dprinteros.com/privacy-policy/)

import QtQuick 2.7
import AppControls 1.0
import AppStyle 1.0
import AppViews 1.0

AbstactPage {

    pageBody: Item {
        anchors.fill: parent

        Grid {
            id: menuGrid
            spacing: AppStyle.theme.defaultMargin * 0.6
            anchors.centerIn: parent
            rows: 1
            columns: 3
            columnSpacing: AppStyle.theme.defaultMargin * 0.6
            rowSpacing: AppStyle.theme.defaultMargin * 0.6

            property real btnWidth: AppStyle.theme.settingsMenuItemWidth
            property real btnHeight: AppStyle.theme.settingsMenuItemHeight

            TextButton {
                width: menuGrid.btnWidth
                height: menuGrid.btnHeight
                text: qsTr("Update from USB")
                onClicked: {
                    filesModel.copyUpdatePackage()
                }
            }

            TextButton {
                width: menuGrid.btnWidth
                height: menuGrid.btnHeight
                text: qsTr("Update certificates")
                onClicked: {
                    filesModel.updateCACerts()
                }
            }

            TextButton {
                width: menuGrid.btnWidth
                height: menuGrid.btnHeight
                text: qsTr("Load settings file")
                onClicked: {
                    filesModel.loadSettingsFile()
                }
            }
        }
    }

    footer {
        nextBtnVisible: false
        onBackClicked: {
            rootItem.back()
        }
    }
}
