import QtQuick 2.0

Rectangle {
    id: root
    // TODO: inherit keyboardItem instead of agregation

    property alias source: keyboardItem.source
    property alias keyWidth: keyboardItem.keyWidth
    property alias keyHeight: keyboardItem.keyHeight
    property alias bounds: keyboardItem.bounds
    property alias mainFont: keyboardItem.mainFont
    property alias mainFontColor: keyboardItem.mainFontColor
    property alias secondaryFont: keyboardItem.secondaryFont
    property alias secondaryFontColor: keyboardItem.secondaryFontColor
    property alias keyColor: keyboardItem.keyColor
    property alias keyPressedColor: keyboardItem.keyPressedColor

    signal enterClicked()
    signal hideClicked()
    signal keyClicked(string key)

    color: "black"
    width: 1024
    height: 640
    
    MouseArea {
        anchors.fill: parent
    }

    KeyboardItem {
        id: keyboardItem
        anchors.centerIn: parent
        source: "keyboard_us.xml"
        onKeyClicked: function(key) {
            root.keyClicked(key)
        }

        onEnterClicked: {
            root.enterClicked()
        }

        onHideClicked: {
            root.hideClicked()
        }

        onSwitchSource: function(source) { root.source = source }
    }
}

