// Copyright 3D Control Systems, Inc. All Rights Reserved 2017-2019.
// Built in San Francisco.

// This software is distributed under a commercial license for personal,
// educational, corporate or any other use.
// The software as a whole or any parts of it is prohibited for distribution or
// use without obtaining a license from 3D Control Systems, Inc.

// All software licenses are subject to the 3DPrinterOS terms of use
// (available at https://www.3dprinteros.com/terms-and-conditions/),
// and privacy policy (available at https://www.3dprinteros.com/privacy-policy/)

import QtQuick 2.7
import QtQuick.Controls 2.4

import AppStyle 1.0
import AppControls 1.0
import AppDialogs 1.0
import "constants.js" as Constants

Item {
    id: readyView
    objectName: Constants.States.IDLE

    ConfirmDialog {
        id: confirmShutdown
        visible: false
        z: 50
        anchors {
            verticalCenterOffset: -AppStyle.theme.headHeight * 0.5
            centerIn: parent
        }
        msg: qsTr("Turn off machine")
        onYes: {
            rootItem.showBusy()
            coreModel.shutdown()
        }
    }

    Item {
        id: infoItem
        width: parent.width * 0.65
        anchors {
            top: parent.top
            left: parent.left
            bottom: parent.bottom
        }
        clip: true

        Column {
            id: infoColumn
            spacing: 20
            anchors {
                verticalCenterOffset: -AppStyle.theme.defaultMargin
                centerIn: parent
            }
            width: parent.width

            Text {
                id: lineText
                width: parent.width
                color: AppStyle.theme.statusTextColor
                text: qsTr("Ready to print")
                horizontalAlignment: Text.AlignHCenter
                font {
                    family: AppStyle.theme.secondFontFamily
                    capitalization: Font.AllUppercase
                    pixelSize: 35
                }
            }

            Text {
                id: infoText
                width: parent.width
                color: AppStyle.theme.textColor
                text: coreModel.offlineMode ? qsTr("Offline mode\nYou can leave offline mode in settings")
                                            : qsTr("Please select a print job in the cloud")
                wrapMode: Text.WordWrap
                horizontalAlignment: Text.AlignHCenter
                font.pixelSize: 25
            }
        }
    }

    Item {
        id: ctrlColumn
        anchors {
            top: parent.top
            right: parent.right
            left: infoItem.right
            bottom: parent.bottom
        }

        Column {
            id: tempColumn
            spacing: 5
            anchors {
                right: parent.right
                top: parent.top
            }
            width: parent.width * 0.9

            KeyValueItem {
                width: parent.width
                keyText: AppStyle.theme.bedTempText + ":"
                valueText: qsTr("%1/%2%3C").arg(printerModel.heatBedTemp).arg(printerModel.heatBedTargetTemp).arg(AppStyle.degreeSymbol)
            }

            KeyValueItem {
                width: parent.width
                keyText: AppStyle.theme.e0TempText + ":"
                valueText: qsTr("%1/%2%3C").arg(printerModel.firstExtruderTemp).arg(printerModel.firstExtruderTargetTemp).arg(AppStyle.degreeSymbol)
            }
        }

        Column {
            id: buttonsColumn
            spacing: printLocalBtn.height * 0.3
            width: parent.width * 0.9
            anchors {
                right: parent.right
                bottom: parent.bottom
            }

            TextButton {
                id: nextCloudPrintBtn
                width: parent.width
                visible: printerModel.nextJobAvailable
                text: qsTr("Start next job")
                onClicked: {
                    printerModel.startNextJob()
                }
            }

            TextButton {
                id: printLocalBtn
                width: parent.width
                text: qsTr("Local print")
                onClicked: {
                    rootItem.pushView("LocalPrintFileList.qml")
                }
            }

            TextButton {
                id: shutDownBtn
                width: parent.width
                text: qsTr("Shutdown")
                onClicked: {
                    confirmShutdown.visible = true
                }
            }
        }
    }

    Component.onCompleted: {
        rootItem.clearHeadMsg()
        rootItem.showHead()
    }
}
