// Copyright 3D Control Systems, Inc. All Rights Reserved 2017-2019.
// Built in San Francisco.

// This software is distributed under a commercial license for personal,
// educational, corporate or any other use.
// The software as a whole or any parts of it is prohibited for distribution or
// use without obtaining a license from 3D Control Systems, Inc.

// All software licenses are subject to the 3DPrinterOS terms of use
// (available at https://www.3dprinteros.com/terms-and-conditions/),
// and privacy policy (available at https://www.3dprinteros.com/privacy-policy/)

import QtQuick 2.7
import QtQuick.Layouts 1.13
import AppStyle 1.0
import AppControls 1.0

Item {
    id: joystickItem

    property var negativeBtnModel: ["-0.1", "-1", "-10", "-100"]
    property var positiveBtnModel: ["100", "10", "1", "0.1"]
    property var zBtnModel: ["100", "10", "1", "0.1", "-0.1", "-1", "-10", "-100"]

    property real btnTextPixelSize: btnHeight * 0.4
    property real btnWidth: 64
    property real btnHeight: 40

    signal xClicked(string value)
    signal yClicked(string value)
    signal zClicked(string value)

    Item {
        id: xyControlItem
        anchors {
            left: parent.left
            top: parent.top
            bottom: parent.bottom
        }

        width: parent.width * 0.7

        Text {
            anchors {
                left: parent.left
                bottom: leftWraper.top
            }
            color: "white"
            text: "-X"
            font {
                pixelSize: 19
                family: AppStyle.theme.secondFontFamily
            }
        }

        Text {
            anchors {
                right: rightWraper.right
                bottom: rightWraper.top
            }
            color: "white"
            text: "+X"
            font {
                pixelSize: 19
                family: AppStyle.theme.secondFontFamily
            }
        }

        Text {
            anchors {
                left: topWraper.right
                leftMargin: 5
                top: parent.top
            }
            color: "white"
            text: "+Y"
            font {
                pixelSize: 19
                family: AppStyle.theme.secondFontFamily
            }
        }

        Text {
            anchors {
                left: topWraper.right
                leftMargin: 5
                bottom: parent.bottom
            }
            color: "white"
            text: "-Y"
            font {
                pixelSize: 19
                family: AppStyle.theme.secondFontFamily
            }
        }

        RoundItem {
            id: leftWraper
            color: "transparent"
            width: leftRow.width
            height: btnWidth

            anchors {
                left: parent.left
                verticalCenter: parent.verticalCenter
            }

            itemPlace: Row {
                id: leftRow
                spacing: 0
                anchors.centerIn: parent
                clip: true
                layoutDirection: Qt.RightToLeft
                height: btnWidth

                Repeater {
                    model: negativeBtnModel

                    TextButton {
                        text: modelData
                        width: btnHeight
                        height: btnWidth
                        clip: true

                        backgroundColor: AppStyle.theme.foreground
                        pressedColor: "transparent"
                        textRotation: -90
                        textPixelSize: btnTextPixelSize
                        onClicked: {
                            console.log(width, height)
                            xClicked(text)
                        }
                    }
                }
            }
        }

        RoundItem {
            id: rightWraper
            color: "transparent"
            width: rightRow.width
            height: btnWidth

            anchors {
                left: topWraper.right
                verticalCenter: parent.verticalCenter
            }

            itemPlace: Row {
                id: rightRow
                spacing: 0
                anchors.centerIn: parent
                clip: true
                layoutDirection: Qt.RightToLeft
                height: btnWidth

                Repeater {
                    model: positiveBtnModel

                    TextButton {
                        text: modelData
                        width: btnHeight
                        height: btnWidth
                        clip: true
                        textRotation: 90
                        backgroundColor: AppStyle.theme.foreground
                        pressedColor: "transparent"
                        textPixelSize: btnTextPixelSize
                        onClicked: {
                            xClicked(text)
                        }
                    }
                }
            }
        }

        RoundItem {
            id: bottomWraper
            anchors {
                bottom: parent.bottom
                left: leftWraper.right
            }

            width: bottomColumn.width
            height: bottomColumn.height

            itemPlace: Column {
                id: bottomColumn
                anchors.centerIn: parent

                Repeater {
                    model: negativeBtnModel

                    TextButton {
                        text: modelData
                        width: btnWidth
                        height: btnHeight
                        backgroundColor: AppStyle.theme.foreground
                        pressedColor: "transparent"
                        textPixelSize: btnTextPixelSize
                        onClicked: {
                            yClicked(text)
                        }
                    }
                }
            }
        }

        RoundItem {
            id: topWraper
            color: "transparent"
            width: topColumn.width
            height: topColumn.height

            anchors {
                top: parent.top
                left: leftWraper.right
            }

            itemPlace: Column {
                id: topColumn
                spacing: 0
                anchors.centerIn: parent
                clip: true

                Repeater {
                    model: positiveBtnModel

                    TextButton {
                        text: modelData
                        width: btnWidth
                        height: btnHeight
                        clip: true
                        backgroundColor: AppStyle.theme.foreground
                        pressedColor: "transparent"
                        textPixelSize: btnTextPixelSize
                        onClicked: {
                            yClicked(text)
                        }
                    }
                }
            }
        }

    }

    Item {
        id: zControlItem
        height: zColumn.height
        anchors {
            verticalCenter: parent.verticalCenter
            left: xyControlItem.right
            leftMargin: AppStyle.theme.defaultMargin
            rightMargin: AppStyle.theme.defaultMargin
        }

        Text {
            anchors {
                right: zWraper.left
                rightMargin: 5
                top: parent.top
            }
            color: "white"
            text: "+Z"
            font {
                pixelSize: 19
                family: AppStyle.theme.secondFontFamily
            }
        }

        Text {
            anchors {
                right: zWraper.left
                rightMargin: 5
                bottom: zWraper.bottom
            }
            color: "white"
            text: "-Z"
            font {
                pixelSize: 19
                family: AppStyle.theme.secondFontFamily
            }
        }

        RoundItem {
            id: zWraper
            width: btnWidth
            height: zColumn.height
            anchors.centerIn: parent
            itemPlace: Column {
                id: zColumn
                width: btnWidth
                spacing: 0
                anchors.centerIn: parent
                clip: true

                Repeater {
                    model: zBtnModel

                    TextButton {
                        text: modelData
                        width: btnWidth
                        height: btnHeight
                        clip: true
                        visible: modelData !== ""
                        backgroundColor: AppStyle.theme.foreground
                        pressedColor: "transparent"
                        textPixelSize: btnTextPixelSize
                        onClicked: {
                            zClicked(text)
                        }
                    }
                }
            }
        }
    }
}
