// Copyright 3D Control Systems, Inc. All Rights Reserved 2017-2019.
// Built in San Francisco.

// This software is distributed under a commercial license for personal,
// educational, corporate or any other use.
// The software as a whole or any parts of it is prohibited for distribution or
// use without obtaining a license from 3D Control Systems, Inc.

// All software licenses are subject to the 3DPrinterOS terms of use
// (available at https://www.3dprinteros.com/terms-and-conditions/),
// and privacy policy (available at https://www.3dprinteros.com/privacy-policy/)

import QtQuick 2.7
import QtQuick.Controls 2.4
import AppStyle 1.0
import AppControls 1.0

AbstractMessageDialog {
    id: confirmRoot
    titleColor: AppStyle.theme.foreground
    titleText: qsTr("Confirmation")

    property bool hideOnBtnClick: true
    property string yesText: qsTr("Yes")
    property string noText: qsTr("No")

    property alias yesAlias: yesBtn
    property alias noAlias: noBtn

    signal yes
    signal no

    buttonsSection: Rectangle {
        anchors.fill: parent
        color: AppStyle.theme.background

        TextButton {
            id: yesBtn
            text: yesText
            anchors {
                top: parent.top
                left: parent.left
                bottom: parent.bottom
            }

            onClicked: {
                confirmRoot.yes()

                if (hideOnBtnClick) {
                    confirmRoot.visible = false
                }
            }
        }

        TextButton {
            id: noBtn
            text: noText
            anchors {
                top: parent.top
                right: parent.right
                bottom: parent.bottom
            }

            onClicked: {
                confirmRoot.no()
                if (hideOnBtnClick) {
                    confirmRoot.visible = false
                }
            }
        }
    }
}
