// Copyright 3D Control Systems, Inc. All Rights Reserved 2017-2019.
// Built in San Francisco.

// This software is distributed under a commercial license for personal,
// educational, corporate or any other use.
// The software as a whole or any parts of it is prohibited for distribution or
// use without obtaining a license from 3D Control Systems, Inc.

// All software licenses are subject to the 3DPrinterOS terms of use
// (available at https://www.3dprinteros.com/terms-and-conditions/),
// and privacy policy (available at https://www.3dprinteros.com/privacy-policy/)

import QtQuick 2.0
import AppStyle 1.0
import "constants.js" as Constants

Rectangle {
    id: head
    width: rootItem.width
    height: AppStyle.theme.headHeight
    color: AppStyle.theme.headColor
    z: 50
    property string headMsg: ""

    Image {
        id: logoImg
        anchors {
            left: parent.left
            leftMargin: head.height * 0.5
            verticalCenter: parent.verticalCenter
        }
        //        height: parent.height * 0.5
        asynchronous: true

        source: AppStyle.theme.logoImgSource
        sourceSize.height: AppStyle.theme.headLogoHeight
        sourceSize.width: AppStyle.theme.headLogoWidth
        onStatusChanged: {
            if (status === Image.Ready) {
                console.log("logo size: ", logoImg.paintedWidth, logoImg.paintedHeight)
            }
        }
    }

    Item {
        id: headMsgItem
        anchors {
            top: parent.top
            left: logoImg.right
            right: settingsRow.left
            bottom: parent.bottom
        }

        Text {
            id: headMsgText
            anchors.centerIn: parent
            text: headMsg
            color: AppStyle.theme.textColor
            font.family: AppStyle.theme.secondFontFamily
            font.pixelSize: parent.height * 0.4
        }
    }

    Row {
        id: settingsRow
        anchors {
            top: parent.top
            right: parent.right
            bottom: parent.bottom
            rightMargin: head.height * 0.5
        }
        clip: true
        spacing: 1

        Item {
            height: settingsRow.height
            width: printerModel.doorOpen ? AppStyle.theme.headItemHeight * 1.55
                                        : AppStyle.theme.headItemHeight * 1.239

            Image {
                id: doorIcon
                anchors.centerIn: parent

                sourceSize.width: parent.width
                sourceSize.height: AppStyle.theme.headItemHeight

                source: printerModel.doorOpen ? AppStyle.theme.imgDir + "close-icon.png"
                                             : AppStyle.theme.imgDir + "open-icon.png"
                asynchronous: true
            }

            MouseArea {
                anchors.fill: parent
                onClicked: {
                    if (coreModel.state === Constants.States.REGISTRATION) {
                        rootItem.showMessageDialog(Constants.MessageTypes.INFO, qsTr("Can't open/close sliding doors while in registeration mode"), "OK")
                        return
                    }

                    if (coreModel.state === Constants.States.CONNECTING) {
                        return
                    }

                    rootItem.showDoorsConfirm()
                }
            }
        }

        Item {
            height: settingsRow.height
            width: AppStyle.theme.headItemHeight

            Image {
                id: lockIcon
                anchors.centerIn: parent
                sourceSize.width: parent.width * 0.45
                sourceSize.height: parent.height * 0.45

                source: rootItem.locked ? AppStyle.theme.imgDir + "lock.svg"
                                        : AppStyle.theme.imgDir + "unlock.svg"
                asynchronous: true
            }

            MouseArea {
                anchors.fill: parent
                onClicked: {
                    if (rootItem.locked) {
                        if (coreModel.state === Constants.States.REGISTRATION) {
                            rootItem.showMessageDialog(Constants.MessageTypes.INFO, qsTr("Can't unlock cover while in registeration mode"), "OK")
                            return
                        }

                        if (coreModel.state === Constants.States.CONNECTING) {
                            return
                        }

                        rootItem.showUnlockConfirm()
                    }
                }
            }
        }

        Item {
            height: settingsRow.height
            width: visible ? AppStyle.theme.headItemHeight : 0
//            visible: rootItem.cleanHeadVisible //TODO: add logic when feuture will be ready
            visible: false
            Image {
                id: cleanPrintHeadIcon
                anchors.centerIn: parent
                source: AppStyle.theme.imgDir + "clean-printhead_icon.png"
                asynchronous: true
                sourceSize.width: AppStyle.theme.headItemHeight * 1.5
                sourceSize.height: AppStyle.theme.headItemHeight * 1.5
            }

            MouseArea {
                anchors.fill: parent
                onClicked: {
                    rootItem.showCleanConfirm()
                }
            }
        }

        Item {
            height: settingsRow.height
            width: AppStyle.theme.headItemHeight

            Image {
                id: settingsIcon
                anchors.centerIn: parent
                source: rootItem.settingsOpened ? AppStyle.theme.imgDir + "cog-off.svg"
                                                : AppStyle.theme.imgDir + "cog.svg"
                asynchronous: true
            }

            MouseArea {
                anchors.fill: parent
                onClicked: {
                    rootItem.showSetting()
                }
            }
        }

        Item {
            height: settingsRow.height
            width: AppStyle.theme.headItemHeight

            Image {
                id: wifiIcon
                asynchronous: true
                anchors.centerIn: parent

                function getWifiSignalImg() {
                    switch(networkModel.wifiSignal) {
                    case 0:
                        return AppStyle.theme.imgDir + "wifi-header-0.png"
                    case 1:
                        return AppStyle.theme.imgDir + "wifi-header-1.png"
                    case 2:
                        return AppStyle.theme.imgDir + "wifi-header-2.png"
                    case 3:
                        return AppStyle.theme.imgDir + "wifi-header-3.png"
                    case 4:
                        return AppStyle.theme.imgDir + "wifi-header-4.png"
                    }
                }

                source: networkModel.connectionIsWired ? AppStyle.theme.imgDir + "network_cable.svg" : getWifiSignalImg()
                sourceSize.width: AppStyle.theme.headItemHeight
                sourceSize.height: AppStyle.theme.headItemHeight
            }
        }
    }
}
