// Copyright 3D Control Systems, Inc. All Rights Reserved 2017-2019.
// Built in San Francisco.

// This software is distributed under a commercial license for personal,
// educational, corporate or any other use.
// The software as a whole or any parts of it is prohibited for distribution or
// use without obtaining a license from 3D Control Systems, Inc.

// All software licenses are subject to the 3DPrinterOS terms of use
// (available at https://www.3dprinteros.com/terms-and-conditions/),
// and privacy policy (available at https://www.3dprinteros.com/privacy-policy/)

import QtQuick 2.7
import AppStyle 1.0
import AppControls 1.0
import AppViews 1.0

AbstactPage {
    id: filamentWait
    property string gcodeToExecute: ""
    property string slotName: ""
    property string title: done ? qsTr("Filament " + slotName + " is ready.")
                                : (filamentWizardRoot.wizardType === FilamentWizard.WizardType.Load
                                   ? qsTr("Filament is loading. Please wait.")
                                   : qsTr("Filament is unloading. Please wait."))
    property bool done: false
    property bool pushedNext: false

    Timer {
        id: repeatPushTimer
        interval: 1500
        repeat: false
        onTriggered: {
            if (filamentWizardRoot.wizardType === FilamentWizard.WizardType.Unload) {
                filamentWizardRoot.pushView("UnloadFinished.qml", {"unloadSlotName": slotName})
            }
        }
        running: false
    }

    footer {
        visible: done
        nextBtnVisible: done
        backBtnVisible: done
        backBtnText: qsTr("Main Menu")
        nextBtnText: qsTr("Load More")
        onBackClicked: {
            rootItem.hideSetting()
        }
        onNextClicked: {
            filamentWizardRoot.pushView("SelectFilamentSlotPage.qml")
        }
        onVisibleChanged: {
            filamentWizardRoot.saveMaterialList()
            if (filamentWizardRoot.wizardType === FilamentWizard.WizardType.Load)
            {
                done = true
            } else if (filamentWizardRoot.wizardType === FilamentWizard.WizardType.Unload && !pushedNext)
            {
                pushedNext = true
                var ret = filamentWizardRoot.pushView("UnloadFinished.qml", {"unloadSlotName": slotName})
                if (!ret) {
                    console.error("Can't push view, repeating after 1.5 sec");
                    repeatPushTimer.start()
                }
            }
        }
    }

    Component.onCompleted: {
        if (gcodeToExecute !== "") {
            console.log(gcodeToExecute)
            printerModel.executeGcodeLine(gcodeToExecute) // first macros call
        }
    }

    pageBody: Item {
        anchors.fill: parent

        Item {
            id: busyItem
            anchors.fill: parent

            Column {
                width: parent.width
                spacing: AppStyle.theme.defaultMargin * 0.5
                anchors.centerIn: parent
                anchors.verticalCenterOffset: AppStyle.theme.defaultMargin * 0.5

                Text {
                    id: infoTextItem
                    text: title
                    width: parent.width
                    verticalAlignment: Text.AlignVCenter
                    horizontalAlignment: Text.AlignHCenter
                    font.pixelSize: 28
                    wrapMode: Text.WordWrap
                    color: AppStyle.theme.textColor
                }

                Item {
                    id: imgWrapper
                    width: parent.width
                    height: gif.height

                    AnimatedImage {
                        id: gif
                        anchors.centerIn: parent
                        width: 400
                        height: 234
                        source: done ? "gifs/completed.gif" : "gifs/loading_final.gif"
                    }
                }
            }
        }
    }
}
