// Copyright 3D Control Systems, Inc. All Rights Reserved 2017-2019.
// Built in San Francisco.

// This software is distributed under a commercial license for personal,
// educational, corporate or any other use.
// The software as a whole or any parts of it is prohibited for distribution or
// use without obtaining a license from 3D Control Systems, Inc.

// All software licenses are subject to the 3DPrinterOS terms of use
// (available at https://www.3dprinteros.com/terms-and-conditions/),
// and privacy policy (available at https://www.3dprinteros.com/privacy-policy/)

import QtQuick 2.7

import AppViews 1.0
import AppStyle 1.0

AbstactPage {
    property string infoText: ""
    property string animSource: ""

    property real animWidth: 412
    property real animHeight: 260
    property real fontPixelSize: 25

    footer.onBackClicked: {
        filamentWizardRoot.cancelWizard()
    }

    pageBody: Item {
        anchors.fill: parent

        Row {
            id: rowItem
            width: parent.width
            height: parent.height * 0.9
            anchors.centerIn: parent
            spacing: AppStyle.theme.defaultMargin

            Item {
                width: parent.width * 0.4
                height: parent.height
                AnimatedImage {
                    id: animItem
                    anchors.centerIn: parent
                    asynchronous: true
                    source: animSource
                    width: animWidth
                    height: animHeight
                }
            }

            Text {
                id: infoTextItem
                text: infoText
                width: parent.width * 0.5
                height: rowItem.height
                verticalAlignment: Text.AlignVCenter
                horizontalAlignment: Text.AlignLeft
                font.pixelSize: fontPixelSize
                wrapMode: Text.WordWrap
                color: AppStyle.theme.textColor
            }
        }
    }
}
