// Copyright 3D Control Systems, Inc. All Rights Reserved 2017-2019.
// Built in San Francisco.

// This software is distributed under a commercial license for personal,
// educational, corporate or any other use.
// The software as a whole or any parts of it is prohibited for distribution or
// use without obtaining a license from 3D Control Systems, Inc.

// All software licenses are subject to the 3DPrinterOS terms of use
// (available at https://www.3dprinteros.com/terms-and-conditions/),
// and privacy policy (available at https://www.3dprinteros.com/privacy-policy/)

import QtQuick 2.7
import AppStyle 1.0
import AppControls 1.0
import AppViews 1.0

AbstactPage {
    id: glovesWarn
    property bool heatingFinished: false
    property string filamentName: ""
    property real customTemp: 0

    footer {
        visible: false
        nextBtnVisible: false
        backBtnVisible: false
        onVisibleChanged: {
            if (footer.visible) {
                if (filamentWizardRoot.wizardType === FilamentWizard.WizardType.Load) {
                    filamentWizardRoot.pushView("LoadInfo1.qml")
                    return
                }

                if (heatingFinished) {
                   // footer.nextBtnVisible = true
                    filamentWizardRoot.pushView("UnloadInfo1.qml")
                    return
                }

                heatingFinished = true
                footer.visible = false
                printerModel.executeGcodeLine('M98 P"retracttorelease.g"') // second macros call
            }
        }
    }

    Component.onCompleted: {
        if (customTemp > 0) {
            printerModel.executeGcodeLine("M109 S" + customTemp)
            return
        }
        printerModel.executeGcodeLine('M98 P"heatfordynamide.g"') // first macros call
    }

    Item {
        anchors.fill: parent

        Column {
            id: tempColumn
            spacing: 5
            anchors {
                right: parent.right
                top: parent.top
            }
            width: parent.width * 0.3

            KeyValueItem {
                width: parent.width
                keyText: qsTr("Print bed:")
                valueText: qsTr("%1/%2%3C").arg(printerModel.heatBedTemp).arg(printerModel.heatBedTargetTemp).arg(AppStyle.degreeSymbol)
            }

            KeyValueItem {
                width: parent.width
                keyText: qsTr("Printhead:")
                valueText: qsTr("%1/%2%3C").arg(printerModel.firstExtruderTemp).arg(printerModel.firstExtruderTargetTemp).arg(AppStyle.degreeSymbol)
            }
        }

        Column {
            width: parent.width
            spacing: AppStyle.theme.defaultMargin * 0.5
            anchors.centerIn: parent
            anchors.verticalCenterOffset: AppStyle.theme.defaultMargin * 0.5

            Text {
                id: infoTextItem
                text: qsTr("Heating the Printhead Please Wait...")
                width: parent.width
                verticalAlignment: Text.AlignVCenter
                horizontalAlignment: Text.AlignHCenter
                font.pixelSize: 25
                wrapMode: Text.WordWrap
                color: AppStyle.theme.textColor
            }

            Item {
                id: imgWrapper
                width: parent.width
                height: gif.height

                AnimatedImage {
                    id: gif
                    anchors.centerIn: parent
                    source: "gifs/waiting.gif"
                }
            }
        }
    }
}
