import QtQuick 2.7
import QtQuick.Controls 2.4
import AppStyle 1.0

Column {
    id: control
    spacing: 0
    width: 120

    property real minValue: 0
    property real maxValue: 50
    property real stepSize: printerModel.zOffsetStep.toFixed(2) //TODO: printerModel.zOffset
    property real value: 0.0

    property real itemHeight: 64

    signal upPressed()
    signal downPressed()

    ImageButton {
        id: up
        width: control.width
        height: itemHeight
//        text: "+"
        backgroundColor: AppStyle.theme.foreground
        pressedColor: AppStyle.theme.background
        imgSource: "../img/arrow-up.png"
        enabled: control.value.toFixed(2) < control.maxValue
        onPressed: {
            control.value += stepSize
            upPressed()
        }
    }

    Rectangle {
        id: valueRect
        width: control.width
        height: itemHeight
        color: "transparent"
        border {
            color: AppStyle.theme.foreground
            width: 1
        }

        Text {
            id: valueText
            font.pixelSize: Math.min(parent.height, parent.width) * 0.4
            clip: true
            anchors.centerIn: parent
            color: AppStyle.theme.textColor
            text: control.value == 0 ? 0 : control.value.toFixed(2)
        }
    }

    ImageButton {
        id: down
        width: control.width
        height: itemHeight
        imgSource: "../img/arrow-down.png"
//        text: "-"
        backgroundColor: AppStyle.theme.foreground
        pressedColor: AppStyle.theme.background
        enabled: control.value.toFixed(2) > control.minValue
        onPressed: {
            control.value -= stepSize
            downPressed()
        }
    }

}
