// Copyright 3D Control Systems, Inc. All Rights Reserved 2017-2019.
// Built in San Francisco.

// This software is distributed under a commercial license for personal,
// educational, corporate or any other use.
// The software as a whole or any parts of it is prohibited for distribution or
// use without obtaining a license from 3D Control Systems, Inc.

// All software licenses are subject to the 3DPrinterOS terms of use
// (available at https://www.3dprinteros.com/terms-and-conditions/),
// and privacy policy (available at https://www.3dprinteros.com/privacy-policy/)

import QtQuick 2.7
import AppControls 1.0
import AppDialogs 1.0
import AppStyle 1.0
import AppViews 1.0
import "FilamentWizard"

AbstactPage {
    id: filamentsMenu

    property real btnWidth: 200
    property real btnHeight: 160

    pageBody: Item {
        anchors.fill: parent

        Row {
            spacing: 30
            anchors.centerIn: parent

            TextButton {
                width: btnWidth
                height: btnHeight
                text: qsTr("Unload Filament")
                onClicked: {
                    rootItem.pushView("FilamentWizard/FilamentWizard.qml", { wizardType: FilamentWizard.WizardType.Unload })
                }
            }

            TextButton {
                width: btnWidth
                height: btnHeight
                text: qsTr("Load Filament")
                onClicked: {
                    rootItem.pushView("FilamentWizard/FilamentWizard.qml", { wizardType: FilamentWizard.WizardType.Load })
                }
            }

            TextButton {
                width: btnWidth
                height: btnHeight
                text: qsTr("Remove Printhead")
                onClicked: {
                    rootItem.pushView("FilamentWizard/FilamentWizard.qml", { wizardType: FilamentWizard.WizardType.RemovePrinthead })
                }
            }
        }
    }

    footer {
       nextBtnVisible: false
       onBackClicked: {
           rootItem.showHead()
           rootItem.back()
       }
    }
}
