import config
import platforms


if platforms.get_platform() == 'rpi' and \
   config.get_settings().get('gpio').get('enabled'):
    try: 
        from periphery_gpio_interface import PeripheryGPIOInterface as GPIOInterface
    except (ImportError, RuntimeError):
        try:
            from rpigpio_interface import RPiGPIOInterface as GPIOInterface
        except (ImportError, RuntimeError):
            # GPIO disabled, will act as a dummy 
            from base_gpio_interface import BaseGPIOInterface as GPIOInterface
else:
    # GPIO disabled, will act as a dummy 
    from base_gpio_interface import BaseGPIOInterface as GPIOInterface
