from aiohttp import web

import web_interface.auth
from . import handlers
from . import api2_handler
from . import button_handlers
from . import tray_handlers
from . import camera_handlers
from . import printer_profiles_handlers
from . import network_printers_handlers
from . import files_handlers

def set_routes(server):
    for route in handlers.PATHS_WITH_FILE_UPLOAD:
        server.router.add_post("/" + route, handlers.multipart_upload_handler)
    server.router.add_get('/http_warning_html', handlers.http_warning_html)
    server.router.add_get('/printers_html', handlers.printers_html)
    server.router.add_get('/telemetry', handlers.telemetry)
    server.router.add_get('/html/printers', handlers.printers_html)
    server.router.add_get('/html/http_warning', handlers.http_warning_html)
    server.router.add_get('/html/camera_modules', handlers.camera_modules_html)
    server.router.add_get('/text/host_version', handlers.host_version)
    server.router.add_get('/pages/{path:.*}', handlers.pages)
    server.router.add_get('/print_files/{path:.*}', files_handlers.print_files_list)
    server.router.add_get('/print_files', files_handlers.print_files_list)
    server.router.add_delete('/print_files/{path:.*}', files_handlers.delete_print_file)
    server.router.add_post('/print_files/{path:.*}', handlers.multipart_upload_handler)
    server.router.add_get('/network_printers', network_printers_handlers.network_printers)
    server.router.add_post('/network_printers', network_printers_handlers.remember_network_printer)
    server.router.add_delete('/network_printers/{printer_id}', network_printers_handlers.forget_network_printer)
    server.router.add_route('*', '/auth', web_interface.auth.auth)
    server.router.add_route('*', '/printer_types', printer_profiles_handlers.get_printer_types)
    server.router.add_route('*', '/printer_profiles', printer_profiles_handlers.get_printer_profiles)
    server.router.add_route('*', '/tray/{path}', tray_handlers.tray)
    server.router.add_route('*', '/toggle_button/{button}', button_handlers.toggle_button)
    server.router.add_route('*', '/camera/urls', camera_handlers.camera_urls)
    server.router.add_route('*', '/camera/{path:.*}', camera_handlers.camera_controller)
    server.router.add_route('*', '/api2/{path:.*}', api2_handler.api2_handler)
    server.router.add_route('*', '/wizard', handlers.wizard_handler)
    server.router.add_route('*', '/wizard/{path:.*}', handlers.wizard_handler)
    server.router.add_route('*', '/reload_pages', handlers.reload_old_static)
    server.router.add_route('*', '/reload_page_former', handlers.reload_page_former)
    server.router.add_route("*", r'/{path:.*}', handlers.legacy_handler)
