# Copyright 3D Control Systems, Inc. All Rights Reserved 2017-2019.
# Built in San Francisco.

# This software is distributed under a commercial license for personal,
# educational, corporate or any other use.
# The software as a whole or any parts of it is prohibited for distribution or
# use without obtaining a license from 3D Control Systems, Inc.

# All software licenses are subject to the 3DPrinterOS terms of use
# (available at https://www.3dprinteros.com/terms-and-conditions/),
# and privacy policy (available at https://www.3dprinteros.com/privacy-policy/)

import sys
import os

# fix of broken paths for windows
if not sys.path:
    sys.path = []
path = os.getcwd()
if path not in sys.path:
    sys.path.append(path)

import user_login

if __name__ == '__main__':
    print("Running post update script")
    print("Patching Makerbot Method X's VID/PID in local printer profiles...")
    NEW_MB_METHOD_VIDS_PIDS = [[
        "23C1",
        "000F"
    ]]
    profiles = user_login.UserLogin.load_local_printer_profiles()
    if profiles:
        for index, profile in enumerate(profiles):
            if profile.get('alias') == "MBMethodX":
                try:
                    profile["vids_pids"] = NEW_MB_METHOD_VIDS_PIDS
                    profiles[index] = profile
                    user_login.UserLogin.save_profiles(profiles)
                    print("..patсhed")
                    break
                except Exception as e:
                    print("Error while patching Makerbot Method's profile")
        else:
            print("Method X not found in printer profiles")
