# Copyright 3D Control Systems, Inc. All Rights Reserved 2017-2025.
# Built in San Francisco.

# This software is distributed under a commercial license for personal,
# educational, corporate or any other use.
# The software as a whole or any parts of it is prohibited for distribution or
# use without obtaining a license from 3D Control Systems, Inc.

# All software licenses are subject to the 3DPrinterOS terms of use
# (available at https://www.3dprinteros.com/terms-and-conditions/),
# and privacy policy (available at https://www.3dprinteros.com/privacy-policy/)

import http_scanner


class HTTPPrusaLinkDetector(http_scanner.HTTPDetector):

    RESPONSE_TEXT_MATCH = "<title>PrusaLink</title>"
    #REQ_HEADERS = {'Accept-Encoding': 'gzip;q=0,deflate,sdch', 'Pragma': 'no-cache'}
    REQ_HEADERS = {'accept-encoding': 'gzip;q=0,deflate,sdch'}


if __name__ == "__main__":
    import logging
    logging.basicConfig(level=logging.DEBUG)
    from pprint import pprint
    d = HTTPPrusaLinkDetector()
    pprint(d.detect())
