# Copyright 3D Control Systems, Inc. All Rights Reserved 2017-2025.
# Built in San Francisco.

# This software is distributed under a commercial license for personal,
# educational, corporate or any other use.
# The software as a whole or any parts of it is prohibited for distribution or
# use without obtaining a license from 3D Control Systems, Inc.

# All software licenses are subject to the 3DPrinterOS terms of use
# (available at https://www.3dprinteros.com/terms-and-conditions/),
# and privacy policy (available at https://www.3dprinteros.com/privacy-policy/)

import http_scanner


class HTTPRRFWDetector(http_scanner.HTTPDetector):

    PATH = "/rr_status"
    RESPONSE_FIELD_NAME = "status"
    TIMEOUT = 2
    #GCODE_REQ_TEMPLATE = "/rr_gcode?gcode=%s" #resp {"buff":250}
    #GET_REPLY_PATH = "/rr_reply"
    #{"status":"O","heaters":[2000.0,2000.0,2000.0],"active":[0.0,0.0,0.0],"standby":[0.0,0.0,0.0],"hstat":[0,0,0],"pos":[0.000,0.000,0.000],"machine":[0.000,0.000,0.000],"sfactor":100.00,"efactor":[100.00,100.00],"babystep":0.000,"tool":-1,"probe":"1000","fanPercent":[0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0],"fanRPM":0,"homed":[0,0,0],"msgBox.mode":-1,"seq":0,"resp":""}


if __name__ == "__main__":
    import logging
    logging.basicConfig(level=logging.DEBUG)
    from pprint import pprint
    d = HTTPRRFWDetector()
    pprint(d.detect())
