function parseQuery(query) {
  const params = {};
  if (!query) return params;
  const parts = query.startsWith('?') ? query.slice(1) : query;
  const pairs = parts.split('&');
  for (const pair of pairs) {
    const [key, value] = pair.split('=');
    if (key) {
      params[key] = decodeURIComponent(value) || true;
    }
  }

  return params;
}
