$(document).ready(function() {
    $('.toggle_button').each( function() {
        let button = this; 
        $.get('/toggle_button/' + button.name, function(resp) {
            button.value = resp;
        });
    });
});

$(document).on('click', '.toggle_button', function(){
    let button = this; 
    let max_duration = 6000;
    let min_duration = 200;
    $(button).css( {'background-image': 'url(/static/images/preloading.png)'}).animate(
            {backgroundPositionX: 0-max_duration/25 + "px"}, max_duration, 'linear',
            function(){ $(button).css({'background-image': 'none', 'background-position-x':'0px'}); }
        );
    $.post('/toggle_button/' + button.name, function(resp) {
        button.value = resp;
        setTimeout(function () {
            $(button).stop();
            $(button).css({'background-image': 'none', 'background-position-x':'0px'});
        }, min_duration)
    }); 
});
