class Manage_network {
    form_selector = '#manage-network-form'
    data = {
        http_proxy: '',
        https_proxy: '',
        enabled: false
    }
    url_proxy_regex = /((http|https)\:\/\/)?[a-zA-Z0-9\.\/\?\:@\-_=#]+(\:[0-9]{2,4})?/
    ip_proxy_regex = /(http|https)\:\/\/\d+\.\d+\.\d+\.\d+(\:\d+)?/

    init() {
        if (this.data.enabled == false) {
            $(this.form_selector).find('input[type="text"]').each(function () {
                this.disabled = true
            })
        }
    }

    validate_proxy_url_or_ip = () => {
        const self = this
        const locData = this.get_form_data()
        const keys = Object.keys(locData)
        this.clear_validate_errors()
        if (this.data.enabled === false) {
            return true
        }
        if (locData.http_proxy === '' && locData.https_proxy === '') {
            $('#http_proxy_error').html('One of proxies should be not empty.<br>Example: http://proxyserver.url:port')
            $('#https_proxy_error').html('One of proxies should be not empty.<br>Example: http://proxyserver.url:port')

            return false;
        }
        const errors = keys.map(function (key) {
            if (locData[key] == '' || typeof locData[key] == "boolean") {
                return true;
            }
            if (locData[key].match(self.url_proxy_regex) != null || locData[key].match(self.ip_proxy_regex) != null) {
                return true;
            }

            return {key: key, text: 'Invalid proxy. Example: http://proxyserver.url:port'}
        }).filter(value => typeof value == "object")

        if (errors.length) {
            this.draw_validate_errors(errors)

            return false
        }
        return true
    }
    draw_validate_errors = (errors = []) => {
        if (errors.length) {
            errors.forEach(function (error) {
                $('#' + error.key + '_error').text(error.text)
            })
        }
    }
    clear_validate_errors = () => {
        const keys = Object.keys(this.data)

        keys.forEach(function (key) {
            $('#' + key + '_error').text('')
        })
    }
    get_form_data = () => {
        const self = this;

        $(this.form_selector).find('input[type="text"]').each(function () {
            if (self.data.hasOwnProperty(this.name)) {
                self.data[this.name] = this.value
            }
        });
        $(this.form_selector).find('input[type="checkbox"]').each(function () {
            if (self.data.hasOwnProperty(this.name)) {
                self.data[this.name] = this.checked
            }
        });

        return this.data
    }

    change_state_proxies_fields(elem) {
        elem.value = elem.checked
        this.data.enabled = elem.checked
        this.clear_validate_errors()
        $(this.form_selector).find('input[type="text"]').each(function () {
            this.disabled = !elem.checked
        })
    }

    async get_current_data() {
        await this.get_proxy_enabled().done(() => {
            this.get_https_proxy().done(() => {
                this.get_http_proxy()
            })
        })
        this.init()
    }

    get_http_proxy() {
        return $.ajax({
            method: "GET",
            url: '/config/get/protocol/proxies/http'
        }).done((response) => {
            $(this.form_selector + ' #http_proxy').val(response)
            this.data.http_proxy = response
            console.log('HTTP:' + response)
        })
    }

    get_https_proxy() {
        return $.ajax({
            method: "GET",
            url: '/config/get/protocol/proxies/https'
        }).done((response) => {
            $(this.form_selector + ' #https_proxy').val(response)
            this.data.https_proxy = response
            console.log('HTTPS:' + response)
        })
    }

    get_proxy_enabled() {
        return $.ajax({
            method: "GET",
            url: '/config/get/protocol/proxies/enabled',
        }).done((response) => {
            $(this.form_selector + ' #enabled').prop('checked', response);
            this.data.enabled = response
            console.log('Enabled:' + response)
        })
    }

}


const manageInstance = new Manage_network()

$(document).ready(function () {
    manageInstance.get_current_data()
})
