import sys
import os

# fix of broken paths for windows
if not sys.path:
    sys.path = []
path = os.getcwd()
if path not in sys.path:
    sys.path.insert(0, path)

import base_cam
from cv_cam import CvUsbDetector, CvUrlListDetector, OpenCVCaptureWrapper, OpenCVFFMPEGCaptureWrapper
from bambulab_ap1_cam import BambulabAP1ListDetector


class CvCamera(base_cam.BaseCamera):

    DETECTORS = [CvUsbDetector, CvUrlListDetector, BambulabAP1ListDetector]


    def get_capture_class_by_cap_id(self, cap_id):
        if isinstance(cap_id, int) or not OpenCVCaptureWrapper.SCHEMA_STRING in cap_id:
            return OpenCVCaptureWrapper
        return OpenCVFFMPEGCaptureWrapper


if __name__ == '__main__':
    CvCamera().run()
