FORM = """      <hr width="320px"> <br>
                <form action="/process_network_printer" method="post" style='display: inline' id="printer_type">
                <div>
                    <input type="text" !!!IP_VALUE!!! name="printer_ip" maxlength="128" placeholder="Printer IP address" class="text_field">
                </div>
                <div>
                    <input type="text" !!!PORT_VALUE!!! name="printer_port" maxlength="16" placeholder="Printer port(empty for auto)" class="text_field">
                </div>
                <div>
                    <input type="text" !!!PASSWORD_VALUE!!! name="password" maxlength="32" placeholder="Printer password" class="text_field" style="display:none">
                </div>
                <div>
                    <input type="text" !!!SNR_VALUE!!! name="serial_number" maxlength="64" placeholder="Printer serial number" class="text_field" style="display:none">
                </div>
                <div>
                    <input type="text" !!!SSH_PASSWORD_VALUE!!! name="ssh_password" maxlength="64" placeholder="Printer SSH password" class="text_field" style="display:none">
                </div>
                <div>
                    <select name="printer_type" onchange="switchFormFields(this)" class="selector">
                    !!!OPTIONS!!!
                    </select>
                </div>
                <div>
                    <input type="button" onClick="sendForm(this.parentElement.parentElement)" value="Add printer" style="" class="big_button">
                </div>
            </form>
"""

def printer_form_html(ip, port, vid, pid, snr, password, ssh_password, set_printer_type, set_conn_id, possible_types_and_conns):
    form = FORM
    options = ''
    for profile, conn_id in possible_types_and_conns:
        printer_name = profile.get('name')
        required_fields = []
        for conn in profile.get('v2', {}).get('connections', []):
            if conn.get('type') == 'LAN':
                if not conn_id or conn_id == conn.get('id'):
                    auth_fields = conn.get('auth_fields', {})
                    for auth in auth_fields:
                        if type(auth) == dict and "id" in auth:
                            field = auth['id']
                            if field != 'IP':
                                required_fields.append(field)
                    break #TODO for now we use only first will in the selector
        else:
            for field in profile.get("network_detect", {}).get('required_fields', []):
                if field not in required_fields:
                    required_fields.append(field)
        required_fields_attr = ""
        if required_fields:
            required_fields_attr = 'required_fields="' + ','.join(required_fields) + '"'
        options += '<option value="' + printer_name + '" ' + required_fields_attr + '>' + printer_name + '</option>\n'
    form_lines = form.splitlines()
    for line in form_lines:
        if (('password' in required_fields or password) and '!!!PASSWORD_VALUE!!!' in line) or\
        (('forced_SNR' in required_fields or snr) and '!!!SNR_VALUE!!!' in line) or\
        (('ssh_password' in required_fields or ssh_password) and '!!!SSH_PASSWORD_VALUE!!!' in line): 
            form = form.replace(line, line.replace('style="display:none"', ''))
    form = form.replace('!!!IP_VALUE!!!', 'value="' + ip + '"')
    form = form.replace('!!!PORT_VALUE!!!', 'value="' + port + '"')
    form = form.replace('!!!SNR_VALUE!!!', 'value="' + snr + '"')
    form = form.replace('!!!PASSWORD_VALUE!!!', 'value="' + password + '"')
    form = form.replace('!!!SSH_PASSWORD_VALUE!!!', 'value="' + ssh_password + '"')
    form = form.replace('!!!OPTIONS!!!', options)
    return form
