import logging
import sys

import platforms

logger = logging.getLogger('gpio')
try: 
    from periphery_gpio_interface import PeripheryGPIOInterface as GPIOInterface
    logger.info('Using python-periphery')
except (ImportError, RuntimeError) as e1:
    logger.warning('Error on load of GPIO interface backend(python-periphery):' + str(e1))
    try:
        logger.info('Attempting import of legacy GPIO backend(RPiGPIO)')
        from rpigpio_interface import RPiGPIOInterface as GPIOInterface
        logger.info('Using python-RPiGPIO')
    except (ImportError, RuntimeError) as e2:
        logger.error('No GPIO backend found, but gpio setting is enabled:' + str(e2))
        GPIOInterface = None
