import logging 

from aiohttp import web, hdrs

from web_interface.auth import check_auth

async def edit_printer(request):
    check_auth(request)
    logger = logging.getLogger('edit_printer')
    if request.content_type == 'application/json':
        post_data = await request.json()
    else:
        post_data = await request.post()
    args = {}
    args.update(post_data)
    printer_id = request.query.get('printer_id')
    if 'VID' not in args or 'PID' not in args or 'SNR' not in args:
        try:
            args['VID'], args['PID'], args['SNR'] = printer_id.strip().split('_', 2)
            try:
                args['SNR'] = args['SNR'].replace('_', '.')
            except:
                pass
        except (KeyError, ValueError, TypeError) as e:
            logger.error('No printer id getting error:' + str(e))
            raise web.HTTPBadRequest(text='No printer id found in post or query')
    logger.error('Edit args: ' + str(args))
    # logger.error('Printer id: ' + str(printer_id))
    for pi in request.app['3dp_app'].printer_interfaces:
        for key in ('VID', 'PID', 'SNR'):
            # logger.info(f"{key} Pi/Post: {pi.usb_info[key]}/{args[key]}")
            if pi.usb_info[key] != args[key]:
                break
        else:
            if request.method == hdrs.METH_GET:
                return web.json_response(data=pi.edit_printer())
            elif request.method == hdrs.METH_POST:
                if pi.edit_printer(args):
                    text = 'Success'
                else:
                    text = 'Edit failed'
                raise web.HTTPFound('/network_printer_list_page', text=text)
                # raise web.HTTPFound('/pages/edit_printer?printer_id=' + printer_id, text=text)
    raise web.HTTPNotFound(text='No printer with that id')
