#
# Copyright 3D Control Systems, Inc. All Rights Reserved 2017-2019. Built in San Francisco.
#
# This software is distributed under commercial non-GPL license for personal, educational,
# corporate or any other use. The software as a whole or any parts of that are prohibited
# for distribution and/or use without obtaining license from 3D Control Systems, Inc.
#
# If you do not have the license to use this software, please delete all software files
# immediately and contact sales to obtain the license: sales@3dprinteros.com.
# If you are unsure about the licensing please contact directly our sales: sales@3dprinteros.com.

import os
import sys
import os.path
import subprocess

import config
import platforms


class TrayController:

    def __init__(self):
        self.tray_process = None
        tray_settings = config.get_settings().get('tray_icon', {})
        if tray_settings.get('enabled'):
            try:
                import pystray_tray as _
                module_name = 'pystray_tray.py'
            except:
                try:
                    import wx as _
                    import wx.adv as _
                    module_name = 'wx_tray.py'
                except:
                    module_name = None
            if module_name:
                module_path = os.path.join(os.path.dirname(os.path.abspath(__file__)), module_name)
                if platforms.get_platform() == 'win':
                    self.tray_process = subprocess.Popen([sys.executable, module_path], close_fds=True, creationflags=subprocess.CREATE_NO_WINDOW)
                else:
                    self.tray_process = subprocess.Popen([sys.executable, module_path], close_fds=True)

    def close(self):
        if self.tray_process:
            try:
                self.tray_process.terminate()
            except:
                pass
