#
# Copyright 3D Control Systems, Inc. All Rights Reserved 2017-2019. Built in San Francisco.
#
# This software is distributed under commercial non-GPL license for personal, educational,
# corporate or any other use. The software as a whole or any parts of that are prohibited
# for distribution and/or use without obtaining license from 3D Control Systems, Inc.
#
# If you do not have the license to use this software, please delete all software files
# immediately and contact sales to obtain the license: sales@3dprinteros.com.
# If you are unsure about the licensing please contact directly our sales: sales@3dprinteros.com.

import logging
import time

class CheckerWaiter:

    CHECK_PERIOD = 0.1
    NAME_FOR_LOGGING = 'place your name for logging here'

    def __init__(self, app, check_function):
        self.check_function = check_function
        self.logger = logging.getLogger(self.__class__.__name__)
        self.logger.setLevel('INFO')
        self.app = app
        self.ignore_flag = False
        self.waiting = not self.check_function()

    def wait(self):
        if self.waiting:
            self.logger.info('Waiting for an action: ' + self.NAME_FOR_LOGGING)
            while not self.check_function() and not self.ignore_flag and not self.app.stop_flag:
                time.sleep(self.CHECK_PERIOD)
            self.waiting = False
            self.logger.info('...end of waiting for: ' + self.NAME_FOR_LOGGING)
        return not self.app.stop_flag