#
# Copyright 3D Control Systems, Inc. All Rights Reserved 2017-2019. Built in San Francisco.
#
# This software is distributed under commercial non-GPL license for personal, educational,
# corporate or any other use. The software as a whole or any parts of that are prohibited
# for distribution and/or use without obtaining license from 3D Control Systems, Inc.
#
# If you do not have the license to use this software, please delete all software files
# immediately and contact sales to obtain the license: sales@3dprinteros.com.
# If you are unsure about the licensing please contact directly our sales: sales@3dprinteros.com.

import sys
import hashlib

import user_login

class DummyApp:
    pass

dummy_app = DummyApp()
dummy_app.stop_flag = False

if __name__ == '__main__':
    login_manager = user_login.UserLogin(app=dummy_app)
    if len(sys.argv) < 3:
        error = 'Two arguments required: login and password'
    else:
        password = hashlib.sha256(sys.argv[2].encode('utf-8')).hexdigest()
        error = login_manager.login_as_user(sys.argv[1], password)
    if error:
        print('Login failed! ' + str(error))
    else:
        print('Login successful: ' + sys.argv[1])
