# Copyright (c) 2017 3D Control Systems LTD

# Author: Maxim Kozlov <m.kozlov@3dprinteos.com>

import sys
import time
import signal
import logging
import requests

import log
import config
import http_client
from dual_cam import Camera


class U3Camera(Camera):
    CAMERA_SHOT_URL = "http://127.0.0.1:8080/?action=snapshot"

    def init(self):
        self.camera_session = requests.sessions.Session()
        self._max_image_size = 100000

    def start(self):
        self.main_loop()

    def main_loop(self):
        time.sleep(self.min_loop_time)
        while not self.stop_flag:
            frame_start_time = time.time()
            try:
                if self.is_same_image_frame():
                    frame = self.SAME_IMAGE_FRAME
                else:
                    response = self.camera_session.request('get', self.CAMERA_SHOT_URL)
                    if response.status_code == 200:
                        frame = response.content
                    else:
                        frame = None
                        self.logger.warn('Can\'t get shot from camera, status code %d' % response.status_code)
                if frame:
                    self.send_frame(frame)
            except Exception as e:
                self.logger.warn('Can\'t get shot from camera: %s' % str(e))
            while time.time() < frame_start_time + 0.001 + self.min_loop_time:
                time.sleep(0.01)
        self.http_client.close()
        sys.exit(0)

if __name__ == "__main__":
    U3Camera()
