#!/bin/bash

INSTALLED_VERSION=$(python3 -c "import requests; print(requests.__version__)")
BUNDLED_VERSION="2.12.4"

echo "Installed requests version: $INSTALLED_VERSION"

if [ "$(printf '%s\n%s\n' "$BUNDLED_VERSION" "$INSTALLED_VERSION" | sort -V | head -n1)" = "$BUNDLED_VERSION" ] \
 && [ "$INSTALLED_VERSION" != "$BUNDLED_VERSION" ]; then
    mv /opt/3dprinteros-client/requests/ /opt/3dprinteros-client/requests_old/
    echo "The installed requests is newer than the bundled one. Disable bundled package."
fi
