#!/bin/bash

echo
echo " _____  ____   ____         _         _                ___   ____  "
echo "|___ / |  _ \ |  _ \  _ __ (_) _ __  | |_  ___  _ __  / _ \ / ___| "
echo "  |_ \ | | | || |_) || '__|| || '_ \ | __|/ _ \| '__|| | | |\___ \ "
echo " ___) || |_| ||  __/ | |   | || | | || |_|  __/| |   | |_| | ___) |"
echo "|____/ |____/ |_|    |_|   |_||_| |_| \__|\___||_|    \___/ |____/ "
echo
echo
echo "Installation of 3DPrinterOS Client for Ultimaker 3/3E/S5/S3 is in progress."
echo "Please wait..."
echo

cd /tmp/3dprinteros-client/install
bash uninstall.sh

mv /tmp/3dprinteros-client /opt/3dprinteros-client

bash check_requests.sh

mkdir -p /root/.3dprinteros
mv /tmp/stuff.bin /root/.3dprinteros

cd /opt/3dprinteros-client
cp install/3dprinteros.client.service /etc/systemd/system/
ln -s /etc/systemd/system/3dprinteros.client.service /etc/systemd/system/multi-user.target.wants/3dprinteros.client.service
systemctl daemon-reload

systemctl start 3dprinteros.client.service

CPU_SERIAL=$(cat /proc/cpuinfo | sed 's/\t//g' | grep 'Serial: ' | head -n 1)
echo "CPU Serial: $CPU_SERIAL"

echo -e "\e[92m3DPrinterOS Client for Ultimaker 3/3E/S5/S3 was successfully installed and started.\e[0m"
if [ ! -f /root/.3dprinteros/auth_client.data ]; then
    echo "You need to make pairing of you printer with 3DPrinterOS Client to have access to U3 API."
    echo "Please accept pairing with "3DPrinterOS Client" application on the U3 printer's screen."
fi
echo